% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{as.data.frame.H2OSegmentModels}
\alias{as.data.frame.H2OSegmentModels}
\title{Converts a collection of Segment Models to a data.frame}
\usage{
\method{as.data.frame}{H2OSegmentModels}(x, ...)
}
\arguments{
\item{x}{Object of class \linkS4class{H2OSegmentModels}.}

\item{...}{Further arguments to be passed down from other methods.}
}
\value{
Returns data.frame with result of segment model training.
}
\description{
Converts a collection of Segment Models to a data.frame
}
\examples{
\dontrun{
library(h2o)
h2o.init()
iris_hf <- as.h2o(iris)
models <- h2o.train_segments(algorithm = "gbm",
                             segment_columns = "Species",
                             x = c(1:3), y = 4,
                             training_frame = iris_hf,
                             ntrees = 5,
                             max_depth = 4)
as.data.frame(models)
}
}
