% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.aecu}
\alias{h2o.aecu}
\title{Retrieve the default AECU (Average Excess Cumulative Uplift = area between AUUC and random AUUC)}
\usage{
h2o.aecu(object, train = FALSE, valid = FALSE, metric = "qini")
}
\arguments{
\item{object}{An \linkS4class{H2OBinomialUpliftMetrics}}

\item{train}{Retrieve the training AECU}

\item{valid}{Retrieve the validation AECU}

\item{metric}{Specify metric of AECU. Posibilities are "qini", "lift", "gain", defaults "qini".}
}
\description{
Retrieves the AECU value from an \linkS4class{H2OBinomialUpliftMetrics}. You need to specificy the type of AECU
using metric parameter. Defaults "qini". Qini AECU equals the Qini value.
If "train" and "valid" parameters are FALSE (default), then the training AECU value is returned. If more
than one parameter is set to TRUE, then a named vector of AECUs are returned, where the names are "train", "valid".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/uplift/criteo_uplift_13k.csv"
train <- h2o.importFile(f)
train$treatment <- as.factor(train$treatment)
train$conversion <- as.factor(train$conversion)

model <- h2o.upliftRandomForest(training_frame=train, x=sprintf("f\%s",seq(0:10)), y="conversion",
                                ntrees=10, max_depth=5, treatment_column="treatment",
                                auuc_type="AUTO")
perf <- h2o.performance(model, train=TRUE) 
h2o.aecu(perf)
}
}
