% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.r2}
\alias{h2o.r2}
\title{Retrieve the R2 value}
\usage{
h2o.r2(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{train}{Retrieve the training R2}

\item{valid}{Retrieve the validation set R2 if a validation set was passed in during model build time.}

\item{xval}{Retrieve the cross-validation R2}
}
\description{
Retrieves the R2 value from an H2O model.
Will return R^2 for GLM Models and will return NaN otherwise.
If "train", "valid", and "xval" parameters are FALSE (default), then the training R2 value is returned. If more
than one parameter is set to TRUE, then a named vector of R2s are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)

h <- h2o.init()
fr <- as.h2o(iris)

m <- h2o.glm(x = 2:5, y = 1, training_frame = fr)

h2o.r2(m)
}
}
