% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.mean_residual_deviance}
\alias{h2o.mean_residual_deviance}
\title{Retrieve the Mean Residual Deviance value}
\usage{
h2o.mean_residual_deviance(object, train = FALSE, valid = FALSE,
  xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{train}{Retrieve the training Mean Residual Deviance}

\item{valid}{Retrieve the validation Mean Residual Deviance}

\item{xval}{Retrieve the cross-validation Mean Residual Deviance}
}
\description{
Retrieves the Mean Residual Deviance value from an H2O model.
If "train", "valid", and "xval" parameters are FALSE (default), then the training Mean Residual Deviance value is returned. If more
than one parameter is set to TRUE, then a named vector of Mean Residual Deviances are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\donttest{
library(h2o)

h <- h2o.init()
fr <- as.h2o(iris)

m <- h2o.deeplearning(x = 2:5, y = 1, training_frame = fr)

h2o.mean_residual_deviance(m)
}
}
