% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.summary}
\alias{h2o.summary}
\alias{summary,H2OFrame-method}
\title{Summarizes the columns of a H2O data frame.}
\usage{
\S4method{summary}{H2OFrame}(object, factors = 6L, ...)
}
\arguments{
\item{object}{An \linkS4class{H2OFrame} object.}

\item{factors}{The number of factors to return in the summary. Default is the top 6.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A table displaying the minimum, 1st quartile, median, mean, 3rd quartile and maximum for each
numeric column, and the levels and category counts of the levels in each categorical column.
}
\description{
A method for the \code{\link{summary}} generic. Summarizes the columns of an H2O data frame or subset of
columns and rows using vector notation (e.g. dataset[row, col])
}
\examples{
\donttest{
library(h2o)
localH2O = h2o.init()
prosPath = system.file("extdata", "prostate.csv", package="h2o")
prostate.hex = h2o.importFile(localH2O, path = prosPath)
summary(prostate.hex)
summary(prostate.hex$GLEASON)
summary(prostate.hex[,4:6])
}
}

