% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.insertMissingValues}
\alias{h2o.insertMissingValues}
\title{Insert Missing Values into an H2OFrame}
\usage{
h2o.insertMissingValues(data, fraction = 0.1, seed = -1)
}
\arguments{
\item{data}{An H2OFrame object representing the dataset.}

\item{fraction}{A number between 0 and 1 indicating the fraction of entries
to replace with missing.}

\item{seed}{A random number used to select which entries to replace with
missing values. Default of \code{seed = -1} will automatically
generate a seed in H2O.}
}
\value{
Returns an H2OFrame object.
}
\description{
Randomly replaces a user-specified fraction of entries in an H2O dataset with missing values.
}
\section{WARNING}{
 This will modify the original dataset. Unless this is intended,
this function should only be called on a subset of the original.
}
\examples{
\donttest{
library(h2o)
h2o.init()
irisPath <- system.file("extdata", "iris.csv", package = "h2o")
iris.hex <- h2o.importFile(path = irisPath)
summary(iris.hex)
irismiss.hex <- h2o.insertMissingValues(iris.hex, fraction = 0.25)
head(irismiss.hex)
summary(irismiss.hex)
}
}

