% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.auc}
\alias{h2o.auc}
\title{Retrieve the AUC}
\usage{
h2o.auc(object, valid = FALSE, ...)
}
\arguments{
\item{object}{An \linkS4class{H2OBinomialMetrics} object.}

\item{valid}{Retrieve the validation AUC}

\item{\dots}{extra arguments to be passed if `object` is of type
\linkS4class{H2OModel} (e.g. train=TRUE)}
}
\description{
Retrieves the AUC value from an \linkS4class{H2OBinomialMetrics}.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
hex <- h2o.uploadFile(prosPath)

hex[,2] <- as.factor(hex[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = hex, distribution = "bernoulli")
perf <- h2o.performance(model, hex)
h2o.auc(perf)
}
}
\seealso{
\code{\link{h2o.giniCoef}} for the Gini coefficient,
         \code{\link{h2o.mse}} for MSE, and \code{\link{h2o.metric}} for the
         various threshold metrics. See \code{\link{h2o.performance}} for
         creating H2OModelMetrics objects.
}

