% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.data.frame.H2OFrame}
\alias{as.data.frame.H2OFrame}
\title{Converts a Parsed H2O data into a Data Frame}
\usage{
\method{as.data.frame}{H2OFrame}(x, ...)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{...}{Further arguments to be passed down from other methods.}
}
\description{
Downloads the H2O data and then scans it in to an R data frame.
}
\examples{
\dontrun{
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
as.data.frame(prostate.hex)
}
}

