% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\encoding{UTF-8}
\name{gyroABt}
\alias{gyroABt}
\title{Point on a gyroline}
\usage{
gyroABt(A, B, t, s = 1, model = "U")
}
\arguments{
\item{A, B}{two distinct points}

\item{t}{a number}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}
}
\value{
A point.
}
\description{
Point of coordinate \code{t} on the gyroline passing through
  two given points \code{A} and \code{B}. This is \code{A} for \code{t=0}
  and this is \code{B} for \code{t=1}. For \code{t=1/2} this is the
  gyromidpoint of the gyrosegment joining \code{A} and \code{B}.
}
