% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.diag.plots.R
\name{gwer.diag.plots}
\alias{gwer.diag.plots}
\title{Diagnostic Plots for Geographically Weighted Elliptical Regression Models}
\usage{
gwer.diag.plots(
  object,
  gwerdiag = NULL,
  which,
  subset = NULL,
  iden = F,
  labels = NULL,
  ret = F,
  ...
)
}
\arguments{
\item{object}{an object with the result of the fitted geographically weighted elliptical regression models.}

\item{gwerdiag}{object list containing the diagnostic measures. By default it is obtained from the object, but can be calculated using \code{\link{gwer.diag}}.}

\item{which}{an optional numeric value with the number of only plot that must be returned.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{iden}{a logical value used to identify observations. If \code{TRUE} the observations are identified by user in the graphic window.}

\item{labels}{a optional string vector specifying a labels plots.}

\item{ret}{a logical value used to return the diagnostic measures computing. If \code{TRUE} the diagnostic measures are returned (see \code{\link{gwer.diag}} for more details).}

\item{...}{graphics parameters to be passed to the plotting routines.}
}
\value{
Return an interactive menu with eleven options to make plots. This menu contains the follows graphics:
1: plot: All.
2: plot: Response residual against fitted values.
3: plot: Response residual against index.
4: plot: Standardized residual against fitted values.
5: plot: Standardized residual against index.
6: plot: QQ-plot of response residuals.
7: plot: QQ-plot of standardized residuals.
8: plot: Generalized leverage.
9: plot: Total local influence index plot for response perturbation.
10: plot: Total local influence index plot scale perturbation.
11: plot: Total local influence index plot case-weight perturbation.
}
\description{
This function generate diagnostic measures plots for the fitted geographically weighted elliptical regression models.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), adapt = TRUE)
gwer.fit.t <- gwer(fit.formula, data = gSRDF, family = Student(3), bandwidth = gwer.bw.t, 
                   adapt = TRUE, parplot = FALSE, hatmatrix = TRUE, spdisp = TRUE, 
                   method = "gwer.fit")
gwer.diag.plots(gwer.fit.t, which=3)
}
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\doi{10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{gwer}}, \code{\link{gwer.diag}}
}
\keyword{Diagnostic}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{Regression}
\keyword{Weighted}
\keyword{methods}
\keyword{models}
\keyword{regression}
