% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streamnetwork.R
\name{get_stream_network_interactively}
\alias{get_stream_network_interactively}
\title{Get Stream Network Interactively}
\usage{
get_stream_network_interactively(
  map = NULL,
  ns = "streamnetwork-ui",
  viewer = shiny::paneViewer(),
  title = "Streamnetwork",
  dem = NULL,
  threshold = 1000,
  ...
)
}
\arguments{
\item{map}{a background leaflet or mapview map to be used for editing. If NULL a blank mapview canvas will be provided.}

\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "Delineate Basin".}

\item{dem}{A raster or terra object dem. (optional)}

\item{threshold}{A threshold for stream initiation. 1000 (default).}

\item{...}{other arguments to \code{leafletOutput()} in module and/or wbt_* functions.}
}
\value{
A list of sf objects that the user collected during shiny session as well as flow accumulation and direction paths to tif.
Each list will contain two sf objects: \code{watersheds} and \code{streams}. The \code{streams} object will also return these attributes:
\code{tribid}, \code{strahler}, \code{slope}, \code{length}, \code{mainstem}, \code{FID}, \code{STRM_VAL}.
}
\description{
This function allows the user to get stream networks and watersheds interactively with a
shiny app. It uses the elevatr package to acquire the Digital Elevation Model (DEM) or user inputted DEM
and whitebox package to delineate the stream network and watersheds (see details).
}
\details{
This function uses the package \link{elevatr} to download the DEM (unless you provide your own).
Once the user has drawn the bounding box or inputed DEM and selected appropriate zoom (resolution) and threshold then
the app will create basins and streams.

\strong{Steps}
\enumerate{
\item Input a well-suited DEM zoom level and threshold. (skip if own DEM is inputted)
\item Draw bounding box (rectangle or polygon) (skip if own DEM is inputted).
\item Wait for layers to respond.
\item Repeat steps 1-4 if needed.
\item when finished, press 'done' and stream network and watersheds will be saved as a list in local environment with the associated
flow accumulation and flow direction.
}

In addition, this function uses both \code{whitebox::wbt_feature_preserving_smoothing()} and \code{whitebox::wbt_breach_depressions()}
prior to running the flow direction and flow accumulation (both d8) algorithms.
}
\note{
If you add your own DEM then you don't need to draw a bounding box.
}
\examples{

if(interactive()){
streamnetwork <- get_stream_network_interactively()
}



}
