% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{study_to_variant}
\alias{study_to_variant}
\title{Map a study id to a variant id}
\usage{
study_to_variant(study_id, verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{study_id}{A character vector of study accession identifiers.}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{warnings}{Whether to print warnings.}
}
\value{
A dataframe of two identifiers. First column is the study identifier
  and the second column is the variant identifier.
}
\description{
Map a study accession identifier to a variant accession identifier.
}
\examples{
\dontrun{
# Map GWAS study identifiers to variant identifiers
study_to_variant(c('GCST001084', 'GCST001085'))
}

}
