% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_svysummary.R
\name{tbl_svysummary}
\alias{tbl_svysummary}
\title{Create a table of summary statistics from a survey object}
\usage{
tbl_svysummary(
  data,
  by = NULL,
  label = NULL,
  statistic = list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~
    "{n} ({p}\%)"),
  digits = NULL,
  type = NULL,
  value = NULL,
  missing = c("ifany", "no", "always"),
  missing_text = "Unknown",
  missing_stat = "{N_miss}",
  sort = all_categorical(FALSE) ~ "alphanumeric",
  percent = c("column", "row", "cell"),
  include = everything()
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
A survey object created with created with \code{survey::svydesign()}}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies summary statistics to display for each variable.  The default is
\code{list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~ "{n} ({p}\%)")}.
See below for details.}

\item{digits}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}. See below for details.}

\item{type}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the summary type. Accepted value are
\code{c("continuous", "continuous2", "categorical", "dichotomous")}.
If not specified, default type is assigned via
\code{assign_summary_type()}. See below for details.}

\item{value}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the level of a variable to display on a single row.
The gtsummary type selectors, e.g. \code{all_dichotomous()}, cannot be used
with this argument. Default is \code{NULL}. See below for details.}

\item{missing, missing_text, missing_stat}{Arguments dictating how and if missing values are presented:
\itemize{
\item \code{missing}: must be one of \code{c("ifany", "no", "always")}
\item \code{missing_text}: string indicating text shown on missing row. Default is \code{"Unknown"}
\item \code{missing_stat}: statistic to show on missing row. Default is \code{"{N_miss}"}.
Possible values are \code{N_miss}, \code{N_obs}, \code{N_nonmiss}, \code{p_miss}, \code{p_nonmiss}.
}}

\item{sort}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies sorting to perform for categorical variables.
Values must be one of \code{c("alphanumeric", "frequency")}.
Default is \code{all_categorical(FALSE) ~ "alphanumeric"}.}

\item{percent}{(\code{string})\cr
Indicates the type of percentage to return.
Must be one of \code{c("column", "row", "cell")}. Default is \code{"column"}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}
}
\value{
A \code{'tbl_svysummary'} object
}
\description{
The \code{tbl_svysummary()} function calculates descriptive statistics for
continuous, categorical, and dichotomous variables taking into account survey weights and design.
}
\section{statistic argument}{

The statistic argument specifies the statistics presented in the table. The
input is a list of formulas that specify the statistics to report. For example,
\code{statistic = list(age ~ "{mean} ({sd})")} would report the mean and
standard deviation for age; \code{statistic = list(all_continuous() ~ "{mean} ({sd})")}
would report the mean and standard deviation for all continuous variables.
A statistic name that appears between curly brackets
will be replaced with the numeric statistic (see \code{\link[glue:glue]{glue::glue()}}).

For categorical variables the following statistics are available to display.
\itemize{
\item \code{{n}} frequency
\item \code{{N}} denominator, or cohort size
\item \code{{p}} proportion
\item \code{{p.std.error}} standard error of the sample proportion computed with \code{\link[survey:surveysummary]{survey::svymean()}}
\item \code{{deff}} design effect of the sample proportion computed with \code{\link[survey:surveysummary]{survey::svymean()}}
\item \code{{n_unweighted}} unweighted frequency
\item \code{{N_unweighted}} unweighted denominator
\item \code{{p_unweighted}} unweighted formatted percentage
}
For continuous variables the following statistics are available to display.
\itemize{
\item \code{{median}} median
\item \code{{mean}} mean
\item \code{{mean.std.error}} standard error of the sample mean computed with \code{\link[survey:surveysummary]{survey::svymean()}}
\item \code{{deff}} design effect of the sample mean computed with \code{\link[survey:surveysummary]{survey::svymean()}}
\item \code{{sd}} standard deviation
\item \code{{var}} variance
\item \code{{min}} minimum
\item \code{{max}} maximum
\item \verb{\{p##\}} any integer percentile, where \verb{##} is an integer from 0 to 100
\item \code{{sum}} sum
}

Unlike \code{\link[=tbl_summary]{tbl_summary()}}, it is not possible to pass a custom function.

For both categorical and continuous variables, statistics on the number of
missing and non-missing observations and their proportions are available to
display.
\itemize{
\item \code{{N_obs}} total number of observations
\item \code{{N_miss}} number of missing observations
\item \code{{N_nonmiss}} number of non-missing observations
\item \code{{p_miss}} percentage of observations missing
\item \code{{p_nonmiss}} percentage of observations not missing
\item \code{{N_obs_unweighted}} unweighted total number of observations
\item \code{{N_miss_unweighted}} unweighted number of missing observations
\item \code{{N_nonmiss_unweighted}} unweighted number of non-missing observations
\item \code{{p_miss_unweighted}} unweighted percentage of observations missing
\item \code{{p_nonmiss_unweighted}} unweighted percentage of observations not missing
}

Note that for categorical variables, \code{{N_obs}}, \code{{N_miss}} and \code{{N_nonmiss}} refer
to the total number, number missing and number non missing observations
in the denominator, not at each level of the categorical variable.
}

\section{type and value arguments}{

There are four summary types. Use the \code{type} argument to change the default summary types.
\itemize{
\item \code{"continuous"} summaries are shown on a \emph{single row}. Most numeric
variables default to summary type continuous.
\item \code{"continuous2"} summaries are shown on \emph{2 or more rows}
\item \code{"categorical"} \emph{multi-line} summaries of nominal data. Character variables,
factor variables, and numeric variables with fewer than 10 unique levels default to
type categorical. To change a numeric variable to continuous that
defaulted to categorical, use \code{type = list(varname ~ "continuous")}
\item \code{"dichotomous"} categorical variables that are displayed on a \emph{single row},
rather than one row per level of the variable.
Variables coded as \code{TRUE}/\code{FALSE}, \code{0}/\code{1}, or \code{yes}/\code{no} are assumed to be dichotomous,
and the \code{TRUE}, \code{1}, and \code{yes} rows are displayed.
Otherwise, the value to display must be specified in the \code{value}
argument, e.g. \code{value = list(varname ~ "level to show")}
}
}

\examples{
\dontshow{if (gtsummary:::is_pkg_installed(c("cardx", "survey"), reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
survey::svydesign(~1, data = as.data.frame(Titanic), weights = ~Freq) |>
  tbl_svysummary(by = Survived, percent = "row", include = c(Class, Age))

# Example 2 ----------------------------------
# A dataset with a complex design
data(api, package = "survey")
survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc) |>
  tbl_svysummary(by = "both", include = c(api00, stype)) |>
  modify_spanning_header(all_stat_cols() ~ "**Survived**")
\dontshow{\}) # examplesIf}
}
\author{
Joseph Larmarange
}
