% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify}
\alias{modify}
\alias{modify_header}
\alias{modify_footnote}
\alias{modify_spanning_header}
\alias{modify_caption}
\alias{show_header_names}
\title{Modify column headers, footnotes, spanning headers, and table captions}
\usage{
modify_header(
  x,
  update = NULL,
  ...,
  text_interpret = c("md", "html"),
  quiet = NULL,
  stat_by = NULL
)

modify_footnote(
  x,
  update = NULL,
  ...,
  abbreviation = FALSE,
  text_interpret = c("md", "html"),
  quiet = NULL
)

modify_spanning_header(
  x,
  update = NULL,
  ...,
  text_interpret = c("md", "html"),
  quiet = NULL
)

modify_caption(x, caption, text_interpret = c("md", "html"))

show_header_names(x = NULL, include_example = TRUE, quiet = NULL)
}
\arguments{
\item{x}{a gtsummary object}

\item{update, ...}{use these arguments to assign updates to headers,
spanning headers, and footnotes. See examples below.
\itemize{
\item \code{update} expects a list of assignments, with the variable name or selector
on the LHS of the formula, and the updated string on the RHS. Also accepts
a named list.
\item \code{...} pass individual updates outside of a list, e.g,
\code{modify_header(p.value = "**P**", all_stat_cols() ~ "**{level}**")}
}

Use the \code{show_header_names()} to see the column names that can be modified.}

\item{text_interpret}{String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.}

\item{quiet}{Logical indicating whether to print messages in console. Default is
\code{FALSE}}

\item{stat_by}{DEPRECATED, use \code{update = all_stat_cols() ~ "<label>"} instead.}

\item{abbreviation}{Logical indicating if an abbreviation is being updated.}

\item{caption}{a string of the table caption/title}

\item{include_example}{logical whether to include print of \code{modify_header()} example}
}
\value{
Updated gtsummary object
}
\description{
These functions assist with updating or adding column headers
(\code{modify_header()}), footnotes (\code{modify_footnote()}), spanning
headers (\code{modify_spanning_header()}), and table captions
(\code{modify_caption()}). Use \code{show_header_names()} to learn
the column names.
}
\section{tbl_summary(), tbl_svysummary(), and tbl_cross()}{

When assigning column headers, footnotes, spanning headers, and captions
for these gtsummary tables,
you may use \code{{N}} to insert the number of observations.
\code{tbl_svysummary} objects additionally have \code{{N_unweighted}} available.

When there is a stratifying \verb{by=} argument present, the following fields are
additionally available to stratifying columns: \code{{level}}, \code{{n}}, and \code{{p}}
(\code{{n_unweighted}} and \code{{p_unweighted}} for \code{tbl_svysummary} objects)

Syntax follows \code{\link[glue:glue]{glue::glue()}}, e.g. \code{all_stat_cols() ~ "**{level}**, N = {n}"}.
}

\section{tbl_regression()}{

When assigning column headers for \code{tbl_regression} tables,
you may use \code{{N}} to insert the number of observations, and \code{{N_event}}
for the number of events (when applicable).
}

\section{captions}{

Captions are assigned based on output type.
\itemize{
\item \code{gt::gt(caption=)}
\item \code{flextable::set_caption(caption=)}
\item \code{huxtable::set_caption(value=)}
\item \code{knitr::kable(caption=)}
}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/modify_ex1.png" alt="image of rendered example table" style="width:45\%;">
}}

\if{html}{Example 2}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/modify_ex2.png" alt="image of rendered example table" style="width:45\%;">
}}

\if{html}{Example 3}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/modify_ex3.png" alt="image of rendered example table" style="width:35\%;">
}}
}

\examples{
\donttest{
# create summary table
tbl <- trial[c("age", "grade", "trt")] \%>\%
  tbl_summary(by = trt, missing = "no") \%>\%
  add_p()

# print the column names that can be modified
show_header_names(tbl)

# Example 1 ----------------------------------
# updating column headers, footnote, and table caption
modify_ex1 <- tbl \%>\%
  modify_header(label = "**Variable**", p.value = "**P**") \%>\%
  modify_footnote(all_stat_cols() ~ "median (IQR) for Age; n (\%) for Grade") \%>\%
  modify_caption("**Patient Characteristics** (N = {N})")

# Example 2 ----------------------------------
# updating headers, remove all footnotes, add spanning header
modify_ex2 <- tbl \%>\%
  modify_header(all_stat_cols() ~ "**{level}**, N = {n} ({style_percent(p)}\%)") \%>\%
  # use `modify_footnote(everything() ~ NA, abbreviation = TRUE)` to delete abbrev. footnotes
  modify_footnote(update = everything() ~ NA) \%>\%
  modify_spanning_header(all_stat_cols() ~ "**Treatment Received**")

# Example 3 ----------------------------------
# updating an abbreviation in table footnote
modify_ex3 <-
  glm(response ~ age + grade, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  modify_footnote(ci = "CI = Credible Interval", abbreviation = TRUE)
}
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n.tbl_summary}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_custom_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_summary}()}

Other tbl_svysummary tools: 
\code{\link{add_n.tbl_summary}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_svysummary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_svysummary}()}

Other tbl_regression tools: 
\code{\link{add_global_p}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_uvregression}()}

Other tbl_survfit tools: 
\code{\link{add_n.tbl_survfit}()},
\code{\link{add_nevent.tbl_survfit}()},
\code{\link{add_p.tbl_survfit}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_survfit}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_survfit tools}
\concept{tbl_svysummary tools}
\concept{tbl_uvregression tools}
