skip_on_cran()
skip_if_not(requireNamespace("lme4"))

library(survival)
fit_cox <- coxph(Surv(time, status) ~ sex, lung)
fit_glm <- glm(response ~ trt, trial, family = binomial)

test_that("add_nevent after tbl_regression creates output without error/warning", {
  # cox model
  expect_error(
    fit_cox %>%
      tbl_regression() %>%
      add_nevent(),
    NA
  )
  expect_warning(
    fit_cox %>%
      tbl_regression() %>%
      add_nevent(),
    NA
  )

  # glm model
  expect_error(
    fit_glm %>%
      tbl_regression() %>%
      add_nevent(),
    NA
  )
  expect_warning(
    fit_glm %>%
      tbl_regression() %>%
      add_nevent(),
    NA
  )
})



test_that("add_nevent after tbl_uvregression creates output without error/warning", {
  # cox model
  expect_error(
    tbl_uvregression(
      trial,
      method = coxph,
      y = Surv(ttdeath, death),
    ) %>%
      add_nevent(),
    NA
  )
  expect_warning(
    tbl_uvregression(
      trial,
      method = coxph,
      y = Surv(ttdeath, death),
    ) %>%
      add_nevent(),
    NA
  )

  # glm model
  expect_error(
    tbl_uvregression(
      trial,
      method = glm,
      y = response,
      method.args = list(family = binomial)
    ) %>%
      add_nevent(),
    NA
  )
  expect_warning(
    tbl_uvregression(
      trial,
      method = glm,
      y = response,
      method.args = list(family = binomial)
    ) %>%
      add_nevent(),
    NA
  )
})

test_that("add_nevent error with bad inputs", {
  expect_error(
    lm(hp ~ mpg, mtcars) %>%
      tbl_regression() %>%
      add_nevent(),
    NULL
  )
  expect_error(
    lme4::lmer(hp ~ mpg + (1 | cyl), mtcars) %>%
      tbl_regression() %>%
      add_nevent(),
    NULL
  )
})

# add_nevent.tbl_surfit --------------------------------------------------------

test_that("add_nevent.tbl_surfit", {
  library(survival)

  tbl_survfit <-
    list(
      survfit(Surv(ttdeath, death) ~ 1, trial),
      survfit(Surv(ttdeath, death) ~ trt, trial)
    ) %>%
    tbl_survfit(times = c(12, 24))

  expect_error(
    add_nevent(tbl_survfit),
    NA
  )
})

# add_nevent.tbl_regression ---------------------------------------------------------
test_that("add_nevent.tbl_regression", {
  tbl <-
    glm(response ~ grade + age, trial, family = binomial) %>%
    tbl_regression()

  expect_error(
    tbl %>% add_nevent(), NA
  )

  expect_error(
    tbl %>% add_nevent(location = "level"), NA
  )

  expect_error(
    tbl %>% add_nevent(location = c("label", "level")), NA
  )
})

# add_nevent.tbl_uvregression ---------------------------------------------------------
test_that("add_nevent.tbl_regression", {
  tbl <-
    trial %>%
    select(response, age, grade) %>%
    tbl_uvregression(
      y = response,
      method = glm,
      method.args = list(family = binomial)
    )

  expect_error(
    tbl %>% add_nevent(), NA
  )

  expect_error(
    tbl %>% add_nevent(location = "level"), NA
  )

  expect_error(
    tbl %>% add_nevent(location = c("label", "level")), NA
  )
})
