% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_hux_table.R
\name{as_hux_table}
\alias{as_hux_table}
\title{Convert gtsummary object to a huxtable object}
\usage{
as_hux_table(
  x,
  include = everything(),
  return_calls = FALSE,
  strip_md_bold = TRUE
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{strip_md_bold}{When TRUE, all double asterisk (markdown language for
bold weight) in column labels and spanning headers are removed.
Default is TRUE}
}
\value{
A {huxtable} object
}
\description{
Function converts a gtsummary object to a huxtable object.
A user can use this function if they wish to add customized formatting
available via the huxtable functions. The huxtable package supports output
to PDF via LaTeX, as well as HTML and Word.
}
\section{Details}{

The \code{as_hux_table()} takes the data frame that will be printed, converts
it to a huxtable and formats the table with the following huxtable functions:
\enumerate{
\item \code{huxtable::huxtable()}
\item \code{huxtable::insert_row()} to insert header rows
\item \code{huxtable::align()} to set column alignment
\item \code{huxtable::set_left_padding()} to indent variable levels
\item \code{huxtable::add_footnote()} to add table footnotes and source notes
\item \code{huxtable::set_bold()} to bold cells
\item \code{huxtable::set_italic()} to italicize cells
\item \code{huxtable::set_na_string()} to use an em-dash for missing numbers
}

Any one of these commands may be omitted using the \verb{include=} argument.
}

\examples{
if (requireNamespace("huxtable"))
  trial \%>\%
    dplyr::select(trt, age, grade) \%>\%
    tbl_summary(by = trt) \%>\%
    add_p() \%>\%
    as_hux_table()
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_gt}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
David Hugh-Jones
}
\concept{gtsummary output types}
