% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_gt.R
\name{as_gt}
\alias{as_gt}
\title{Convert gtsummary object to a gt object}
\usage{
as_gt(
  x,
  include = everything(),
  return_calls = FALSE,
  ...,
  exclude = NULL,
  omit = NULL
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{...}{Arguments passed on to \link[gt:gt]{gt::gt}}

\item{exclude}{DEPRECATED.}

\item{omit}{DEPRECATED.}
}
\value{
A \code{gt_tbl} object
}
\description{
Function converts a gtsummary object to a gt_tbl object.
Function is used in the background when the results are printed or knit.
A user can use this function if they wish to add customized formatting
available via the \href{https://gt.rstudio.com/index.html}{gt package}.

Review the
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_summary.html#advanced}{tbl_summary vignette}
or
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#advanced}{tbl_regression vignette}
for detailed examples in the 'Advanced Customization' section.
}
\section{Example Output}{


\if{html}{\figure{as_gt_ex.png}{options: width=50\%}}
}

\examples{
as_gt_ex <-
  trial[c("trt", "age", "response", "grade")] \%>\%
  tbl_summary(by = trt) \%>\%
  as_gt()
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
