% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_sigfig.R
\name{style_sigfig}
\alias{style_sigfig}
\title{Implement significant figure-like rounding}
\usage{
style_sigfig(x, digits = 2)
}
\arguments{
\item{x}{Numeric vector}

\item{digits}{Integer specifying the minimum number of significant
digits to display}
}
\value{
A character vector of styled numbers
}
\description{
Converts a numeric argument into a string that has been rounded to a
significant figure-like number. Scientific notation output
is avoided, however, and additional significant figures may be displayed for
large numbers.  For example, if the number of significant digits
requested is 2, 123 will be displayed (rather than 120 or 1.2x10^2).
}
\details{
If 2 sig figs are input, the number is rounded to 2 decimal places
when \code{abs(x) < 1}, 1 decimal place when \code{abs(x) >= 1 & abs(x) < 10},
and to the nearest integer when \code{abs(x) >= 10}.
}
\examples{
c(0.123, 0.9, 1.1234, 12.345, -0.123, -0.9, -1.1234, -12.345, NA, -0.001) \%>\%
  style_sigfig()
}
\author{
Daniel D. Sjoberg
}
