% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_header.R
\name{modify_header.fmt_table1}
\alias{modify_header.fmt_table1}
\title{Modifies header rows for existing \code{fmt_table1} objects.}
\usage{
\method{modify_header}{fmt_table1}(x, label = NULL, stat_by = NULL,
  stat_overall = NULL, pvalue = NULL, ...)
}
\arguments{
\item{x}{\code{fmt_table1} object}

\item{label}{string vector including text to appear above the label column}

\item{stat_by}{string vector of text to include above the summary statistics
stratified by a variable.  The following fields are available for use in the
headers: \code{n}, \code{N}, \code{p}, \code{name}, and \code{level}.  \code{n} is the number of observations in
each by group. \code{N} is the total number of observations. \code{p} is the percentage of rows
in a by group. \code{name} is the name of the by variable. \code{level} is the by variable level.
Syntax follows the \code{glue::glue()} function, e.g. \code{stat_by = c("{level}", "N = {n} ({p}\\\%)")}.
Must specify \code{by} along with \code{stat_by}.}

\item{stat_overall}{string vector including text to appear above the overall summary
statistics. \code{N}, the total number of observations, is available for use in the
description.}

\item{pvalue}{string vector including text to appear above the p-value column}

\item{...}{further arguments passed to or from other methods}
}
\description{
If the top row of a header column is blank,
you may experience printing issues when using \code{knitr}::\code{\link[knitr]{kable}}
}
\examples{
trial \%>\% fmt_table1(by = "trt") \%>\% modify_header(stat_by = c("{level}", "N = {n} ({p}\%)"))
}
