% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_highlight_rows.R
\name{gt_highlight_rows}
\alias{gt_highlight_rows}
\title{Add color highlighting to a specific row}
\usage{
gt_highlight_rows(
  gt_object,
  columns = gt::everything(),
  rows = TRUE,
  fill = "#80bcd8",
  alpha = 0.8,
  font_weight = "bold",
  bold_target_only = FALSE,
  target_col = c()
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{Specific columns to apply color to, accepts either \code{tidyeval} colum names or columns by position.}

\item{rows}{The rows to apply the highlight to. Can either by a \code{tidyeval} compliant statement (like \code{cyl == 4}), a number indicating specific row(s) to apply color to or \code{TRUE} to indicate all rows.}

\item{fill}{A character string indicating the fill color. If nothing is provided, then "#80bcd8" (light blue) will be used as a default.}

\item{alpha}{An optional alpha transparency value for the color as single value in the range of 0 (fully transparent) to 1 (fully opaque). If not provided the fill color will either be fully opaque or use alpha information from the color value if it is supplied in the #RRGGBBAA format.}

\item{font_weight}{A string or number indicating the weight of the font. Can be a text-based keyword such as "normal", "bold", "lighter", "bolder", or, a numeric value between 1 and 1000, inclusive. Note that only variable fonts may support the numeric mapping of weight.}

\item{bold_target_only}{A logical of TRUE/FALSE indicating whether to apply bold to only the specific \code{target_col}. You must indicate a specific column with \code{target_col}.}

\item{target_col}{A specific \code{tidyeval} column to apply bold text to, which allows for normal weight text for the remaining highlighted columns.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_highlight_rows} function takes an existing \code{gt_tbl} object and
adds highlighting color to the cell background of a specific row. The function
accepts rows only by number (not by logical expression) for now.
}
\section{Figures}{

\if{html}{\figure{highlight-basic.png}{options: width=70\%}}
\if{html}{\figure{highlight-target.png}{options: width=70\%}}
}

\section{Function ID}{

2-10
}

\examples{
library(gt)
basic_use <- head(mtcars[,1:5]) \%>\%
 tibble::rownames_to_column("car") \%>\%
   gt() \%>\%
   gt_highlight_rows(rows = 2, font_weight = "normal")

target_bold_column <- head(mtcars[,1:5]) \%>\%
   tibble::rownames_to_column("car") \%>\%
   gt() \%>\%
   gt_highlight_rows(
     rows = 5,
     fill = "lightgrey",
     bold_target_only = TRUE,
     target_col = car
   )

}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
