% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_transform.R
\name{text_case_match}
\alias{text_case_match}
\title{Perform whole or partial text replacements with a 'switch'-like approach}
\usage{
text_case_match(
  .data,
  ...,
  .default = NULL,
  .replace = c("all", "partial"),
  .locations = cells_body()
)
}
\arguments{
\item{.data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{...}{A sequence of two-sided formulas matching this general
construction: \verb{<old_text> ~ <new_text>}. The left hand side (LHS)
determines which values to match on and it can be any length (allowing for
\code{new_text} to replace different values of \code{old_text}). The right hand side
(RHS) provides the replacement text (it must resolve to a single value of
the \code{character} class).}

\item{.default}{The replacement text to use when cell values aren't matched
by any of the LHS inputs. If \code{NULL}, the default, no replacement text will
be used.}

\item{.replace}{A choice in how the matching is to be done. The default
\code{"all"} means that the \code{old_text} (on the LHS of formulas given in \code{...})
must match the cell text \emph{completely}. With that option, the replacement
will completely replace that matched text. With \code{"partial"}, the match will
occur in all substrings of \code{old_text}. In this way, the replacements will
act on those matched substrings.}

\item{.locations}{The cell or set of cells to be associated with the text
transformation. Only the \code{\link[=cells_body]{cells_body()}}, \code{\link[=cells_stub]{cells_stub()}},
\code{\link[=cells_column_labels]{cells_column_labels()}}, and \code{\link[=cells_row_groups]{cells_row_groups()}} helper functions can be
used here. We can enclose several of these calls within a \code{list()} if we
wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{text_case_match()} function provides a useful interface for a approach
to replacing table cells that behaves much like a switch statement. The
targeting of cells for transformation happens with the \code{.locations} argument.
Once overall targeting is handled, you need to supply a sequence of two-sided
formulas matching of the general form: \verb{<vector_old_text> ~ <new_text>}. In
the left hand side (LHS) there should be a character vector containing
strings to match on. The right hand side (RHS) should contain a single string
(or something coercible to a length one character vector). There's also the
\code{.replace} argument that changes the matching and replacing behavior. By
default, \code{text_case_match()} will try to match on entire strings and replace
those strings. This can be changed to a partial matching and replacement
strategy with the alternate option.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. In the \code{char} column, transform the
\code{NA} value to \code{"elderberry"}. Over in the \code{fctr} column, perform some
sophisticated matches on spelled-out numbers and replace with descriptive
text. Here, we use a \code{.default} to replace text for any of those non-matched
cases.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(char, fctr) |>
  gt() |>
  text_case_match(
    NA ~ "elderberry",
    .locations = cells_body(columns = char)
  ) |>
  text_case_match(
    vec_fmt_spelled_num(1:4) ~ "one to four",
    vec_fmt_spelled_num(5:6) ~ "five or six",
    .default = "seven or more",
    .locations = cells_body(columns = fctr)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_text_case_match_1.png" alt="This image of a table was generated from the first code example in the `text_case_match()` help file." style="width:100\%;">
}}

Use \code{\link{towny}} to create a \strong{gt} table. Transform the text in the
\code{csd_type} column using two-sided formulas supplied to \code{text_case_match()}.
We can replace matches on the LHS with Fontawesome icons furnished by the
\strong{fontawesome} R package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{towny |>
  dplyr::select(name, csd_type, population_2021) |>
  dplyr::filter(csd_type \%in\% c("city", "town")) |>
  dplyr::group_by(csd_type) |>
  dplyr::arrange(desc(population_2021)) |>
  dplyr::slice_head(n = 5) |>
  dplyr::ungroup() |>
  gt() |>
  fmt_integer() |>
  text_case_match(
    "city" ~ fontawesome::fa("city"),
    "town" ~ fontawesome::fa("house-chimney")
  ) |>
  cols_label(
    name = "City/Town",
    csd_type = "",
    population_2021 = "Population"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_text_case_match_2.png" alt="This image of a table was generated from the second code example in the `text_case_match()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

4-3
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other text transforming functions: 
\code{\link{text_case_when}()},
\code{\link{text_replace}()},
\code{\link{text_transform}()}
}
\concept{text transforming functions}
