% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{html}
\alias{html}
\title{Interpret input text as HTML-formatted text}
\usage{
html(text, ...)
}
\arguments{
\item{text, ...}{The text that is understood to be HTML text, which is to be
preserved.}
}
\value{
A character object of class \code{html}. It's tagged as an HTML fragment
that is not to be sanitized.
}
\description{
For certain pieces of text (like in column labels or table headings) we may
want to express them as raw HTML. In fact, with HTML, anything goes so it can
be much more than just text. The \code{html()} function will guard the input HTML
against escaping, so, your HTML tags will come through as HTML when
rendered... to HTML.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. When adding a title, use the
\code{html()} helper to use HTML formatting.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  dplyr::select(currency, char) \%>\%
  gt() \%>\%
  tab_header(title = html("<em>HTML</em>"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_html_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

7-2
}

\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
