% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_merge_uncert}
\alias{cols_merge_uncert}
\title{Merge two columns to a value & uncertainty column}
\usage{
cols_merge_uncert(data, col_val, col_uncert, sep = " +/- ", autohide = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{col_val}{A single column name that contains the base values. This is
the column where values will be mutated.}

\item{col_uncert}{A single column name that contains the uncertainty values.
These values will be combined with those in \code{col_val}. We have the option
to automatically hide the \code{col_uncert} column through \code{autohide}.}

\item{sep}{The separator text that contains the uncertainty mark. The
default value of \code{" +/- "} indicates that an appropriate plus/minus mark
will be used depending on the output context. Should you want this special
symbol to be taken literally, it can be supplied within the base \code{\link[=I]{I()}}
function.}

\item{autohide}{An option to automatically hide the column specified as
\code{col_uncert}. Any columns with their state changed to hidden will behave
the same as before, they just won't be displayed in the finalized table.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{cols_merge_uncert()} function is a specialized variant of the
\code{\link[=cols_merge]{cols_merge()}} function. It operates by taking a base value column
(\code{col_val}) and an uncertainty column (\code{col_uncert}) and merges them into a
single column. What results is a column with values and associated
uncertainties (e.g., \verb{12.0 ± 0.1}), and, the column specified in \code{col_uncert}
is dropped from the output table.
}
\details{
This function could be somewhat replicated using \code{\link[=cols_merge]{cols_merge()}}, however,
\code{cols_merge_uncert()} employs the following specialized semantics for \code{NA}
handling:

\enumerate{
\item \code{NA}s in \code{col_val} result in missing values for the merged
column (e.g., \code{NA} + \code{0.1} = \code{NA})
\item \code{NA}s in \code{col_uncert} (but not \code{col_val}) result in
base values only for the merged column (e.g.,
\code{12.0} + \code{NA} = \code{12.0})
\item \code{NA}s both \code{col_val} and \code{col_uncert} result in
missing values for the merged column (e.g., \code{NA} + \code{NA} =
\code{NA})
}

Any resulting \code{NA} values in the \code{col_val} column following the merge
operation can be easily formatted using the \code{\link[=fmt_missing]{fmt_missing()}} function.

This function is part of a set of three column-merging functions. The other
two are the general \code{\link[=cols_merge]{cols_merge()}} function and the specialized
\code{\link[=cols_merge_range]{cols_merge_range()}} function. These functions operate similarly, where the
non-target columns can be optionally hidden from the output table through the
\code{hide_columns} or \code{autohide} options.
}
\section{Figures}{

\if{html}{\figure{man_cols_merge_uncert_1.png}{options: width=100\%}}
}

\section{Function ID}{

4-8
}

\examples{
# Use `exibble` to create a gt table,
# keeping only the `currency` and `num`
# columns; merge columns into one with
# a base value and uncertainty (after
# formatting the `num` column)
tab_1 <-
  exibble \%>\%
  dplyr::select(currency, num) \%>\%
  dplyr::slice(1:7) \%>\%
  gt() \%>\%
  fmt_number(
    columns = vars(num),
    decimals = 3,
    use_seps = FALSE
  ) \%>\%
  cols_merge_uncert(
    col_val = vars(currency),
    col_uncert = vars(num)
  ) \%>\%
  cols_label(
    currency = "value + uncert."
  )

}
\seealso{
Other Modify Columns: 
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_width}()}
}
\concept{Modify Columns}
