% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_source_notes}
\alias{cells_source_notes}
\title{Location helper for targeting the source notes}
\usage{
cells_source_notes()
}
\value{
A list object with the classes \code{cells_source_notes} and
\code{location_cells}.
}
\description{
\code{cells_source_notes()} is used to target all source notes in the
footer section of the table. This is useful for adding custom styles to the
source notes with \code{\link[=tab_style]{tab_style()}} (using the \code{locations} argument). The
'source_notes' location is generated by \code{\link[=tab_source_note]{tab_source_note()}}.
}
\section{Examples}{


Let's use a subset of the \code{\link{gtcars}} dataset to create a \strong{gt} table. Add a
source note (with \code{\link[=tab_source_note]{tab_source_note()}}) and style the source notes section
inside \code{\link[=tab_style]{tab_style()}} with \code{locations = cells_source_notes()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(mfr, model, msrp) |>
  dplyr::slice(1:5) |>
  gt() |>
  tab_source_note(source_note = "From edmunds.com") |>
  tab_style(
    style = cell_text(
      color = "#A9A9A9",
      size = "small"
    ),
    locations = cells_source_notes()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_source_notes_1.png" alt="This image of a table was generated from the first code example in the `cells_source_notes()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-24
}

\section{Function Introduced}{

\code{v0.3.0} (May 12, 2021)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
