% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_stubhead}
\alias{cells_stubhead}
\title{Location helper for targeting the table stubhead cell}
\usage{
cells_stubhead()
}
\value{
A list object with the classes \code{cells_stubhead} and \code{location_cells}.
}
\description{
\code{cells_stubhead()} is used to target the table stubhead location
when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or adding custom style with
\code{\link[=tab_style]{tab_style()}}. The function is expressly used in each of those functions'
\code{locations} argument. The 'stubhead' location is always present alongside the
'stub' location.
}
\section{Examples}{


Using a summarized version of the \code{\link{pizzaplace}} dataset, let's create a
\strong{gt} table. Add a stubhead label with \code{\link[=tab_stubhead]{tab_stubhead()}} and then style it
with \code{\link[=tab_style]{tab_style()}} in conjunction with the use of \code{cells_stubhead()} in the
\code{locations} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pizzaplace |>
  dplyr::mutate(month = as.numeric(substr(date, 6, 7))) |>
  dplyr::group_by(month, type) |>
  dplyr::summarize(sold = dplyr::n(), .groups = "drop") |>
  dplyr::filter(month \%in\% 1:2) |>
  gt(rowname_col = "type") |>
  tab_stubhead(label = "type") |>
  tab_style(
    style = cell_fill(color = "lightblue"),
    locations = cells_stubhead()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_stubhead_1.png" alt="This image of a table was generated from the first code example in the `cells_stubhead()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-13
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
