% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_O2sol_SP_pt}
\alias{gsw_O2sol_SP_pt}
\title{Oxygen Solubility in Seawater (UNESCO variables)}
\usage{
gsw_O2sol_SP_pt(SP, pt)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
Oxygen solubility in micro-moles per kg.
}
\description{
Computes oxygen concentration for seawater that is equilibrium with
vapour-saturated air at standard atmospheric pressure (101.325 kPa,
i.e. for sea pressure of 0dbar).  The formula, not created by the SCOR/IAPSO
Working Group 127 nor approved by the IOC, is stated in the TEOS-10
documentation to be from Benson and Krause (1984), as fitted by
Garcia and Gordon (1992, 1993). That formulation is framed in UNESCO-era
water properties; see \code{\link{gsw_O2sol}} for the corresponding
computation in GSW variables.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SP <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
O2sol <- gsw_O2sol_SP_pt(SP, pt)
stopifnot(all.equal(O2sol/100, c(1.946825431692940, 1.956135062814438,
            2.146559360234014, 2.735652832698713, 2.951580761415903,
            3.129598716631408)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_O2sol_SP_pt.html}
}
\seealso{
Other things related to oxygen: 
\code{\link{gsw_O2sol}()}
}
\concept{things related to oxygen}
