% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SA_from_SP_Baltic}
\alias{gsw_SA_from_SP_Baltic}
\title{Convert from Practical Salinity to Absolute Salinity (Baltic)}
\usage{
gsw_SA_from_SP_Baltic(SP, longitude, latitude)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
Absolute Salinity [ g/kg ]
}
\description{
Calculate Absolute Salinity from Practical Salinity, pressure,
longitude, and latitude.
}
\details{
If SP is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.

The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SP <- c( 6.5683, 6.6719, 6.8108, 7.2629, 7.4825, 10.2796)
lon <- c(    20,     20,     20,     20,     20,      20)
lat <- c(    59,     59,     59,     59,     59,      59)
SA <- gsw_SA_from_SP_Baltic(SP, lon, lat)
expect_equal(SA, c(6.669945432342856, 6.773776430742856, 6.912986138057142,
                 7.366094191885713, 7.586183837142856, 10.389520570971428))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SA_from_SP_Baltic.html}
}
\seealso{
Other things related to salinity: \code{\link{gsw_C_from_SP}},
  \code{\link{gsw_SA_from_SP}},
  \code{\link{gsw_SA_from_Sstar}},
  \code{\link{gsw_SP_from_C}},
  \code{\link{gsw_SP_from_SA}},
  \code{\link{gsw_SP_from_SK}},
  \code{\link{gsw_SP_from_SR}},
  \code{\link{gsw_SP_from_Sstar}},
  \code{\link{gsw_SR_from_SP}},
  \code{\link{gsw_Sstar_from_SA}},
  \code{\link{gsw_Sstar_from_SP}},
  \code{\link{gsw_deltaSA_from_SP}}
}
