% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_geo_strf_dyn_height_pc}
\alias{gsw_geo_strf_dyn_height_pc}
\title{Geostrophic Dynamic Height Anomaly (Piecewise-Constant Profile)}
\usage{
gsw_geo_strf_dyn_height_pc(SA, CT, delta_p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{delta_p}{difference in sea pressure between the deep and
shallow limits of layers within which \code{SA} and \code{CT} are 
assumed to be constant. Note that \code{delta_p} must be positive.}
}
\value{
A list containing \code{dyn_height}, the dynamic height anomaly [ m^2/s^2 ], and
\code{p_mid} [ dbar ], the pressures at the layer centres. Note that the dynamic height
anomaly unit, also known as a "dynamic meter", corresponds to approximately 1.02 metres of sealevel height
(see e.g. Talley et al., 2011. Descriptive Physical Oceanography, 6th edition.
Elsevier).
}
\description{
Geostrophic Dynamic Height Anomaly (Piecewise-Constant Profile)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
delta_p <- c(10,      40,      75,     125,     350,     400)
r <- gsw_geo_strf_dyn_height_pc(SA, CT, delta_p)
expect_equal(r$dyn_height, c(-0.300346215853487, -1.755165998114308, -4.423531083131365,
                           -6.816659136254657, -9.453175257818430, -12.721009624991439))
expect_equal(r$p_mid/1e2, c(0.050000000000000, 0.300000000000000, 0.875000000000000,
                          1.875000000000000, 4.250000000000000, 8.000000000000000))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_geo_strf_dyn_height.html}
}
