% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{nominalSig}
\alias{nominalSig}
\title{Calculate Nominal Significance, Standard Approach}
\usage{
nominalSig(gammaVec, cvec)
}
\arguments{
\item{gammaVec}{square root of information.}

\item{cvec}{group sequential boundary.}
}
\value{
nominal significance
}
\description{
Nominal significance for the secondary endpoint are calculated by using the standard (original) approach.
}
\details{
This function calculates he nominal significance level of any given boundary.
}
\examples{
#require(mvtnorm)
#require(ldbounds)
#nSig <- nominalSig(gammaVec=c(sqrt(1/3),1),cvec=c(2.2,1.8))

}
\references{
O'Brien, P. C., and Fleming, T. R. (1979). A multiple testing procedure for clinical trials. \emph{Biometrics} \bold{35}, 549-556.

 Pocock, S. J. (1977). Group sequential methods in the design and analysis of clinical trials. \emph{Biometrika} \bold{64}, 191-199.

 Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, to appear.
}
\seealso{
\code{ldNominalSig}, \code{secondaryBoundaryVecOrig}
}
\author{
Jiangtao Gou
}
