% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{trans_location}
\alias{trans_location}
\title{Find translocations}
\usage{
trans_location(dat, sb, min = 1L)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf" and "rratio"
and two vectors "chr" and "pos".}

\item{sb}{synteny_info object}

\item{min}{Integer, minimal number of markers below / above threshold.}
}
\value{
norm_data object including a CNA object.
}
\description{
Synteny blocks and CNVs are combined to detect matching translocations.
}
\examples{
\dontrun{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
data("synteny_blocks", package = "brassicaData", envir = environment())
dat <- trans_location(dat, synteny_blocks, min = 5)
}
}
}

