% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{logLik.gsl_nls}
\alias{logLik.gsl_nls}
\title{Extract model log-likelihood}
\usage{
\method{logLik}{gsl_nls}(object, REML = FALSE, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{REML}{logical value; included for compatibility reasons only, should not be used.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric object of class \code{"logLik"} identical to \code{\link[stats]{logLik}}.
}
\description{
Returns the model log-likelihood of a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n, 
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

logLik(obj)
}
\seealso{
\code{\link[stats]{logLik}}
}
