% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqz.R
\name{freqz}
\alias{freqz}
\alias{freqz.default}
\alias{freqz.Arma}
\alias{freqz.Ma}
\alias{freqz.Sos}
\alias{freqz.Zpg}
\alias{print.freqz}
\alias{summary.freqz}
\alias{print.summary.freqz}
\alias{freqz_plot}
\title{Frequency response of digital filter}
\usage{
freqz(filt, ...)

\method{freqz}{default}(
  filt,
  a = 1,
  n = 512,
  whole = ifelse((is.numeric(filt) && is.numeric(a)), FALSE, TRUE),
  fs = 2 * pi,
  ...
)

\method{freqz}{Arma}(
  filt,
  n = 512,
  whole = ifelse((is.numeric(filt$b) && is.numeric(filt$a)), FALSE, TRUE),
  fs = 2 * pi,
  ...
)

\method{freqz}{Ma}(
  filt,
  n = 512,
  whole = ifelse(is.numeric(filt), FALSE, TRUE),
  fs = 2 * pi,
  ...
)

\method{freqz}{Sos}(filt, n = 512, whole = FALSE, fs = 2 * pi, ...)

\method{freqz}{Zpg}(filt, n = 512, whole = FALSE, fs = 2 * pi, ...)

\method{print}{freqz}(x, ...)

\method{summary}{freqz}(object, ...)

\method{print}{summary.freqz}(x, ...)

freqz_plot(w, h, ...)
}
\arguments{
\item{filt}{for the default case, the moving-average coefficients of an ARMA
model or filter. Generically, \code{filt} specifies an arbitrary model or
filter operation.}

\item{...}{for methods of \code{freqz}, arguments are passed to the default
method. For \code{freqz_plot}, additional arguments are passed through to
plot.}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter.}

\item{n}{number of points at which to evaluate the frequency response. If
\code{n} is a vector with a length greater than 1, then evaluate the
frequency response at these points. For fastest computation, \code{n}
should factor into a small number of small primes. Default: 512.}

\item{whole}{FALSE (the default) to evaluate around the upper half of the
unit circle or TRUE to evaluate around the entire unit circle.}

\item{fs}{sampling frequency in Hz. If not specified (default = 2 * pi), the
frequencies are in radians.}

\item{x}{object to be printed or plotted.}

\item{object}{object of class \code{"freqz"} for \code{summary}}

\item{w}{vector of frequencies}

\item{h}{complex frequency response \eqn{H(e^{j\omega})}, specified as a
vector.}
}
\value{
For \code{freqz}, a list of class \code{'freqz'} with items:
\describe{
  \item{h}{complex array of frequency responses at frequencies \code{f}.}
  \item{w}{array of frequencies.}
  \item{u}{units of (angular) frequency; either rad/s or Hz.}
}
}
\description{
Compute the z-plane frequency response of an ARMA model or rational IIR
filter.
}
\details{
The frequency response of a digital filter can be interpreted as the transfer
function evaluated at \eqn{z = e^{j\omega}}.

The 'Matlab' and 'Octave' versions of \code{freqz} produce magnitude and
phase plots. The \code{freqz} version in the 'signal' package produces
separate plots of magnitude in the pass band (max - 3 dB to max) and stop
(total) bands, as well as a phase plot. The current version produces slightly
different plots. The magnitude plots are separate for stop and pass bands,
but the pass band plot has an absolute lower limit of -3 dB instead of max -
3 dB. In addition a \code{summary} method was added that prints out the most
important information about the frequency response of the filter.
}
\note{
When results of \code{freqz} are printed, \code{freqz_plot} will be
  called to display frequency plots of magnitude and phase. As with lattice
  plots, automatic printing does not work inside loops and function calls, so
  explicit calls to print or plot are needed there.
}
\examples{
b <- c(1, 0, -1)
a <- c(1, 0, 0, 0, 0.25)
freqz(b, a)

hw <- freqz(b, a)
summary(hw)

}
\author{
John W. Eaton, Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
 Port to R by Tom Short,\cr
 adapted by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
