% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upfirdn.R
\name{upfirdn}
\alias{upfirdn}
\title{Upsample, apply FIR filter, downsample}
\usage{
upfirdn(x, h, p = 1, q = 1)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{h}{Impulse response of the FIR filter specified as a numeric vector or
matrix. If it is a vector, then it represents one FIR filter to may be
applied to multiple signals in \code{x}; if it is a matrix, then each
column is a separate FIR impulse response.}

\item{p}{Upsampling factor, specified as a positive integer (default: 1).}

\item{q}{downsampling factor, specified as a positive integer (default: 1).}
}
\value{
output signal, returned as a vector or matrix. Each column has length
  \code{ceiling(((length(x) - 1) * p + length(h)) / q)}.
}
\description{
Filter and resample a signal using polyphase interpolation.
}
\details{
upfirdn performs a cascade of three operations:
\enumerate{
  \item Upsample the input data in the matrix \code{x} by a factor of the
    integer \code{p} (inserting zeros)
  \item FIR filter the upsampled signal data with the impulse response
    sequence given in the vector or matrix \code{h}
  \item Downsample the result by a factor of the integer \code{q} (throwing
    away samples)
}

The FIR filter is usually a lowpass filter, which you must design using
another function such as \code{fir1}.
}
\note{
This function uses a polyphase implementation, which is generally
  faster than using \code{filter} by a factor equal to the downsampling
  factor, since it only calculates the needed outputs.
}
\examples{

x <- c(1, 1, 1)
h <- c(1, 1)

## FIR filter
y <- upfirdn(x, h)

## FIR filter + upsampling
y <- upfirdn(x, h, 5)

## FIR filter + downsampling
y <- upfirdn(x, h, 1, 2)

## FIR filter + up/downsampling
y <- upfirdn(x, h, 5, 2)




}
\seealso{
\code{\link{fir1}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
