% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shanwavf.R
\name{shanwavf}
\alias{shanwavf}
\title{Complex Shannon Wavelet}
\usage{
shanwavf(lb = -8, ub = 8, n = 1000, fb = 5, fc = 1)
}
\arguments{
\item{lb, ub}{Lower and upper bounds of the interval to evaluate the waveform
on. Default: -8 to 8.}

\item{n}{Number of points on the grid between \code{lb} and \code{ub} (length
of the wavelet). Default: 1000.}

\item{fb}{Time-decay parameter of the wavelet (bandwidth in the frequency
domain). Must be a positive scalar. Default: 5.}

\item{fc}{Center frequency of the wavelet. Must be a positive scalar.
Default: 1.}
}
\value{
A list containing 2 variables; \code{x}, the grid on which the
  complex Shannon wavelet was evaluated, and \code{psi} (\eqn{\Psi}), the
  evaluated wavelet on the grid \code{x}.
}
\description{
Compute the Complex Shannon wavelet.
}
\details{
The complex Shannon wavelet is defined by a bandwidth parameter \code{fb}, a
wavelet center frequency \code{fc}, and the expression
\deqn{\psi(x) = (fb^{0.5} * (sinc(fb * x) * e^{2 * 1i * pi * fc * x}))}
on an \code{n}-point regular grid in the interval of \code{lb} to \code{ub}.
}
\examples{

fb <- 1
fc <- 1.5
lb <- -20
ub <- 20
n <- 1000
sw <- shanwavf(lb, ub, n, fb, fc)
op <- par(mfrow = c(2,1))
plot(sw$x, Re(sw$psi), type="l", main = "Complex Shannon Wavelet",
     xlab = "real part", ylab = "")
plot(sw$x, Im(sw$psi), type="l", xlab = "imaginary part", ylab = "")
par(op)

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
