% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw_info.R
\name{pw_info}
\alias{pw_info}
\title{Average hazard ratio under non-proportional hazards}
\usage{
pw_info(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  total_duration = 30,
  ratio = 1
)
}
\arguments{
\item{enroll_rate}{An \code{enroll_rate} data frame with or without stratum
created by \code{\link[=define_enroll_rate]{define_enroll_rate()}}.}

\item{fail_rate}{A \code{fail_rate} data frame with or without stratum
created by \code{\link[=define_fail_rate]{define_fail_rate()}}.}

\item{total_duration}{Total follow-up from start of enrollment to data
cutoff; this can be a single value or a vector of positive numbers.}

\item{ratio}{Experimental:Control randomization ratio.}
}
\value{
A data frame with \code{time} (from \code{total_duration}), \code{stratum}, \code{t},
\code{hr} (hazard ratio), \code{event} (expected number of events), \code{info}
(information under given scenarios), \code{info0} (information under related
null hypothesis), and \code{n} (sample size) for each value of \code{total_duration}
input
}
\description{
Provides a geometric average hazard ratio under
various non-proportional hazards assumptions for either single or multiple strata studies.
The piecewise exponential distribution allows a simple method to specify a distribution
and enrollment pattern where the enrollment, failure and dropout rates changes over time.
}
\examples{
# Example: default
pw_info()

# Example: default with multiple analysis times (varying total_duration)
pw_info(total_duration = c(15, 30))

# Stratified population
enroll_rate <- define_enroll_rate(
  stratum = c(rep("Low", 2), rep("High", 3)),
  duration = c(2, 10, 4, 4, 8),
  rate = c(5, 10, 0, 3, 6)
)
fail_rate <- define_fail_rate(
  stratum = c(rep("Low", 2), rep("High", 2)),
  duration = c(1, Inf, 1, Inf),
  fail_rate = c(.1, .2, .3, .4),
  dropout_rate = .001,
  hr = c(.9, .75, .8, .6)
)
# Give results by change-points in the piecewise model
ahr(enroll_rate = enroll_rate, fail_rate = fail_rate, total_duration = c(15, 30))

# Same example, give results by strata and time period
pw_info(enroll_rate = enroll_rate, fail_rate = fail_rate, total_duration = c(15, 30))
}
