% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_power_ahr.R
\name{gs_power_ahr}
\alias{gs_power_ahr}
\title{Group sequential design power using average hazard ratio under
non-proportional hazards}
\usage{
gs_power_ahr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = rep(0.001, 2)),
  event = c(30, 40, 50),
  analysis_time = NULL,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = NULL),
  test_lower = TRUE,
  test_upper = TRUE,
  ratio = 1,
  binding = FALSE,
  h1_spending = TRUE,
  info_scale = c("h0_h1_info", "h0_info", "h1_info"),
  r = 18,
  tol = 1e-06,
  interval = c(0.01, 1000),
  integer = FALSE
)
}
\arguments{
\item{enroll_rate}{Enrollment rates defined by \code{define_enroll_rate()}.}

\item{fail_rate}{Failure and dropout rates defined by \code{define_fail_rate()}.}

\item{event}{A numerical vector specifying the targeted events at each analysis. See details.}

\item{analysis_time}{Targeted calendar timing of analyses. See details.}

\item{upper}{Function to compute upper bound.
\itemize{
\item \code{gs_spending_bound()}: alpha-spending efficacy bounds.
\item \code{gs_b()}: fixed efficacy bounds.
}}

\item{upar}{Parameters passed to \code{upper}.
\itemize{
\item If \code{upper = gs_b}, then \code{upar} is a numerical vector specifying the fixed efficacy bounds per analysis.
\item If \code{upper = gs_spending_bound}, then \code{upar} is a list including
\itemize{
\item \code{sf} for the spending function family.
\item \code{total_spend} for total alpha spend.
\item \code{param} for the parameter of the spending function.
\item \code{timing} specifies spending time if different from information-based spending; see details.
}
}}

\item{lower}{Function to compute lower bound, which can be set up similarly as \code{upper}.
See \href{https://merck.github.io/gsDesign2/articles/story-seven-test-types.html}{this vignette}.}

\item{lpar}{Parameters passed to \code{lower}, which can be set up similarly as \code{upar.}}

\item{test_lower}{Indicator of which analyses should include an lower bound;
single value of \code{TRUE} (default) indicates all analyses;
single value \code{FALSE} indicated no lower bound; otherwise, a logical vector
of the same length as \code{info} should indicate which analyses will have a
lower bound.}

\item{test_upper}{Indicator of which analyses should include an upper
(efficacy) bound; single value of \code{TRUE} (default) indicates all analyses;
otherwise, a logical vector of the same length as \code{info} should indicate
which analyses will have an efficacy bound.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{h1_spending}{Indicator that lower bound to be set by spending
under alternate hypothesis (input \code{fail_rate})
if spending is used for lower bound.
If this is \code{FALSE}, then the lower bound spending is under the null hypothesis.
This is for two-sided symmetric or asymmetric testing under the null hypothesis;
See \href{https://merck.github.io/gsDesign2/articles/story-seven-test-types.html}{this vignette}.}

\item{info_scale}{Information scale for calculation. Options are:
\itemize{
\item \code{"h0_h1_info"} (default): variance under both null and alternative hypotheses is used.
\item \code{"h0_info"}: variance under null hypothesis is used.
\item \code{"h1_info"}: variance under alternative hypothesis is used.
}}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000); default is 18, range is 1 to 80.
Larger values provide larger number of grid points and greater accuracy.
Normally, \code{r} will not be changed by the user.}

\item{tol}{Tolerance parameter for boundary convergence (on Z-scale); normally not changed by the user.}

\item{interval}{An interval presumed to include the times at which
expected event count is equal to targeted event.
Normally, this can be ignored by the user as it is set to \code{c(.01, 1000)}.}

\item{integer}{Indicator of whether integer sample size and events are intended. This argument is
used when using \code{\link[=to_integer]{to_integer()}}.}
}
\value{
A list with input parameters, enrollment rate, analysis, and bound.
\itemize{
\item \verb{$input} a list including \code{alpha}, \code{beta}, \code{ratio}, etc.
\item \verb{$enroll_rate} a table showing the enrollment, which is the same as input.
\item \verb{$fail_rate} a table showing the failure and dropout rates, which is the same as input.
\item \verb{$bound} a table summarizing the efficacy and futility bound at each analysis.
\item \code{analysis} a table summarizing the analysis time, sample size, events, average HR, treatment effect and statistical information at each analysis.
}
}
\description{
Calculate power given the sample size in group sequential design power using average hazard ratio under
non-proportional hazards.
}
\details{
Note that time units are arbitrary, but should be the same for all rate parameters in \code{enroll_rate}, \code{fail_rate}, and \code{analysis_time}.

Computed bounds satisfy input upper bound specification in
\code{upper}, \code{upar}, and lower bound specification in \code{lower}, \code{lpar}.
\code{\link[=ahr]{ahr()}} computes statistical information at targeted event times.
The \code{\link[=expected_time]{expected_time()}} function is used to get events and average HR at
targeted \code{analysis_time}.

The parameters \code{event} and \code{analysis_time} are used to determine the timing for interim and final analyses.
\itemize{
\item If analysis timing is to be determined by targeted events,
then \code{event} is a numerical vector specifying the targeted events for each analysis;
note that this can be NULL.
\item If interim analysis is determined by targeted calendar timing relative to start of enrollment,
then \code{analysis_time} will be a vector specifying the calendar time from start of study for each analysis;
note that this can be NULL.
\item A corresponding element of \code{event} or \code{analysis_time} should be provided for each analysis.
\item If both \code{event[i]} and \code{analysis[i]} are provided for analysis \code{i}, then the time corresponding to the
later of these is used  for analysis \code{i}.
}
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Calculate information and effect size based on AHR approximation
   using \code{gs_info_ahr()}.
   \item Return a tibble of with columns Analysis, Bound, Z, Probability,
   theta, Time, AHR, Events and  contains a row for each analysis
   and each bound.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign2)
library(dplyr)

# Example 1 ----
# The default output of `gs_power_ahr()` is driven by events,
# i.e., `event = c(30, 40, 50)`, `analysis_time = NULL`
\donttest{
gs_power_ahr(lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.1))
}
# Example 2 ----
# 2-sided symmetric O'Brien-Fleming spending bound, driven by analysis time,
# i.e., `event = NULL`, `analysis_time = c(12, 24, 36)`

gs_power_ahr(
  analysis_time = c(12, 24, 36),
  event = NULL,
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025)
)

# Example 3 ----
# 2-sided symmetric O'Brien-Fleming spending bound, driven by event,
# i.e., `event = c(20, 50, 70)`, `analysis_time = NULL`
# Note that this assumes targeted final events for the design is 70 events.
# If actual targeted final events were 65, then `timing = c(20, 50, 70) / 65`
# would be added to `upar` and `lpar` lists.
# NOTE: at present the computed information fraction in output `analysis` is based
# on 70 events rather than 65 events when the `timing` argument is used in this way.
# A vignette on this topic will be forthcoming.
\donttest{
gs_power_ahr(
  analysis_time = NULL,
  event = c(20, 50, 70),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025)
)
}
# Example 4 ----
# 2-sided symmetric O'Brien-Fleming spending bound,
# driven by both `event` and `analysis_time`, i.e.,
# both `event` and `analysis_time` are not `NULL`,
# then the analysis will driven by the maximal one, i.e.,
# Time = max(analysis_time, calculated Time for targeted event)
# Events = max(events, calculated events for targeted analysis_time)
\donttest{
gs_power_ahr(
  analysis_time = c(12, 24, 36),
  event = c(30, 40, 50), h1_spending = FALSE,
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025)
)
}
}
