% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgraph.R
\name{hGraph}
\alias{hGraph}
\title{Create multiplicity graphs using ggplot2}
\usage{
hGraph(
  nHypotheses = 4,
  nameHypotheses = paste("H", (1:nHypotheses), sep = ""),
  alphaHypotheses = 0.025/nHypotheses,
  m = matrix(array(1/(nHypotheses - 1), nHypotheses^2), nrow = nHypotheses) -
    diag(1/(nHypotheses - 1), nHypotheses),
  fill = 1,
  palette = grDevices::gray.colors(length(unique(fill)), start = 0.5, end = 0.8),
  labels = LETTERS[1:length(unique(fill))],
  legend.name = " ",
  legend.position = "none",
  halfWid = 0.5,
  halfHgt = 0.5,
  trhw = 0.1,
  trhh = 0.075,
  trprop = 1/3,
  digits = 5,
  trdigits = 2,
  size = 6,
  boxtextsize = 4,
  arrowsize = 0.02,
  radianStart = if ((nHypotheses)\%\%2 != 0) {
     pi * (1/2 + 1/nHypotheses)
 } else {

        pi * (1 + 2/nHypotheses)/2
 },
  offset = pi/4/nHypotheses,
  xradius = 2,
  yradius = xradius,
  x = NULL,
  y = NULL,
  wchar = if (as.character(Sys.info()[1]) == "Windows") {
     "w"
 } else {
     "w"
 }
)
}
\arguments{
\item{nHypotheses}{number of hypotheses in graph}

\item{nameHypotheses}{hypothesis names}

\item{alphaHypotheses}{alpha-levels or weights for ellipses}

\item{m}{square transition matrix of dimension `nHypotheses`}

\item{fill}{grouping variable for hypotheses}

\item{palette}{colors for groups}

\item{labels}{text labels for groups}

\item{legend.name}{text for legend header}

\item{legend.position}{text string or x,y coordinates for legend}

\item{halfWid}{half width of ellipses}

\item{halfHgt}{half height of ellipses}

\item{trhw}{transition box width}

\item{trhh}{transition box height}

\item{trprop}{proportion of transition arrow length where transition box is placed}

\item{digits}{number of digits to show for alphaHypotheses}

\item{trdigits}{digits displayed for transition weights}

\item{size}{text size in ellipses}

\item{boxtextsize}{transition text size}

\item{arrowsize}{size of arrowhead for transition arrows}

\item{radianStart}{radians from origin for first ellipse; nodes spaced equally in clockwise order with centers on an ellipse by default}

\item{offset}{rotational offset in radians for transition weight arrows}

\item{xradius}{horizontal ellipse diameter on which ellipses are drawn}

\item{yradius}{vertical ellipse diameter on which ellipses are drawn}

\item{x}{x coordinates for hypothesis ellipses if elliptical arrangement is not wanted}

\item{y}{y coordinates for hypothesis ellipses if elliptical arrangement is not wanted}

\item{wchar}{character for alphaHypotheses in ellipses}
}
\value{
A `ggplot` object with a multi-layer multiplicity graph
}
\description{
\code{hGraph()} plots a multiplicity graph defined by user inputs.
The graph can also be used with the **gMCPLite** package to evaluate a set of nominal p-values for the tests of the hypotheses in the graph
}
\details{
See vignette **Multiplicity graphs formatting using ggplot2** for explanation of formatting.
}
\examples{
# 'gsDesign::hGraph' is deprecated.
# See the examples in 'gMCPLite::hGraph' instead.
}
