% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{gr_report}
\alias{gr_report}
\title{Report hydrograph separation and variables}
\usage{
gr_report(
  sep,
  vars,
  output = "Report.html",
  year = NULL,
  exclude = NULL,
  temp = FALSE,
  prec = FALSE,
  span = 5,
  locale = "EN"
)
}
\arguments{
\item{sep}{\code{data.frame} of hydrograph separation as returned by \code{\link[=gr_separate]{gr_separate()}} function.}

\item{vars}{\code{data.frame} of hydrograph variables as returned by \code{\link[=gr_summarize]{gr_summarize()}} function.}

\item{output}{Character string path to the output file. Must have \code{.html} extension.}

\item{year}{Integer value of year used to divide series in two samples compared by Student and Fisher tests. Defaults to \code{NULL} which means that the year is calculated automatically by Pettitt test. Defaults to \code{NULL}.}

\item{exclude}{Integer vector of years to be excluded from reporting. Defaults to \code{NULL}.}

\item{temp}{Boolean. Plot temperature on the top of hydrograph? Defaults to \code{FALSE}. If both \code{temp = TRUE} and \code{prec = TRUE}, then the axis is drawn for precipitation.}

\item{prec}{Boolean. Plot precipitation on the top of hydrograph? Defaults to \code{FALSE}. If both \code{temp = TRUE} and \code{prec = TRUE}, then the axis is drawn for precipitation.}

\item{span}{Integer number of days to accumulate precipitation for plotting. Defaults to \code{5}.}

\item{locale}{Character string locale. Currently only English (\code{'EN'}) and Russian (\code{'RU'}) locales are supported. Defaults to \code{'EN'}.}
}
\value{
No return value, called for side effects
}
\description{
This function generates a graphical HTML report that summarizes separation of hydrograph, its variables and their statistical properties. See example \href{https://www.dropbox.com/s/747xyqp65ipriy5/Spas-Zagorye.html}{report} generated by this command for \code{spas} dataset included in grwat package.
}
\examples{
\dontrun{
  library(grwat)
  
  data(spas) # example Spas-Zagorye data is included with grwat package
  
  # separate
  sep = gr_separate(spas, params = gr_get_params(reg = 'center'))
  
  # summarize
  vars = gr_summarize(sep)
  
  # report
  report = '~/Spas-Zagorye.html'
  
  gr_report(sep, vars, output = report)
  browseURL(report)
}
}
