% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_ridge}
\alias{gr_plot_ridge}
\title{Ridgeline hydrograph plot}
\usage{
gr_plot_ridge(
  df,
  years,
  pal = 4,
  rev = FALSE,
  scale = 0.01,
  alpha = 0.8,
  print = TRUE
)
}
\arguments{
\item{df}{\code{data.frame} with date (1st) and runoff (2nd) columns.}

\item{years}{Integer vector of years to be plotted.}

\item{pal}{Numeric or character string. Color palette identifier passed to \code{\link[ggplot2:scale_brewer]{ggplot2::scale_fill_distiller()}}.}

\item{rev}{Boolean. Reverse the palette? Defaults to \code{FALSE}.}

\item{scale}{Numeric scale factor passed to \code{\link[ggridges:geom_ridgeline]{ggridges::geom_ridgeline()}}. Defaults to \code{0.01}.}

\item{alpha}{Numeric opacity value of the ridgeline plot. Defaults to \code{0.8}.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{ggplot2} object representing the multiple river hydrographs at once using the ridgeline plot approach
}
\description{
A convenient wrapper around \code{\link[ggridges:geom_ridgeline]{ggridges::geom_ridgeline()}} to visualize multiple river hydrographs at once.
}
\examples{
if (require("ggridges")) {
  
  library(grwat)
  
  data(spas) # example Spas-Zagorye data is included with grwat package
  
  # separate
  sep = gr_separate(spas, params = gr_get_params(reg = 'center'))
  
  # ridgline plot for selected years
  gr_plot_ridge(sep, years = c(1960, 1965, 1989, 2001, 2012)) 

}
}
