% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.summary.grpreg.R
\name{print.summary.grpreg}
\alias{print.summary.grpreg}
\title{Summarize a fitted \code{grpreg} object}
\usage{
\method{print}{summary.grpreg}(x, digits = 4, ...)
}
\arguments{
\item{x}{A "\code{summary.grpreg}" object.}

\item{digits}{Number of digits past the decimal point to print out. The default is \code{4}.}

\item{...}{Optional arguments passed to other methods.}
}
\value{
A list with class "\code{summary.grpreg}" containing the following components:
\item{n}{Number of observations.}
\item{p}{Number of screened predictors.}
\item{penalty}{The penalty applied to the model.}
\item{model}{The type of model.}
\item{family}{The link function.}
\item{criterion}{The screening criterion.}
\item{lambda}{The default or specified regularization parameter.}
\item{beta}{The estimates of coefficients at the specified \code{lambda}.}
\item{iter}{The number of iterations at the specified \code{lambda}.}
\item{df}{The estimates of effective number of model parameters at the specified
 \code{lambda}.}
\item{call}{The function call.}
Additional elements are contained for the case in which \code{family = "gaussian"}:
\item{r.squared}{The r.squared.}
\item{snr}{The signal-to-noise ratio.}
\item{scale}{The scale parameter estimate.}
and following elements for the case in which \code{family = "poisson"} or \code{"binomial"}:
\item{logLik}{The negative log-likelihood values for the fitted model.}
\item{aic}{Akaike's information criterion (AIC).}
\item{bic}{Bayesian information criterion (BIC).}
\item{aicc}{The AIC with a correction for finite sample sizes (AICC).}
\item{pe}{The prediction error for \code{family = "binomial"}.}
}
\description{
Summarizes a fitted penalized regression model with '\code{grpreg}' class.
}
\details{
The default \code{lambda} is the one at which we obtain the minimum loss
(i.e., negative log-likelihood value), if \code{lambda} is not specified.
}
\author{
Debin Qiu, Jeongyoun Ahn
}
\seealso{
\code{\link{summary.cv.grpreg}}
}
\keyword{internal}

