% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spline.R
\name{plot_spline}
\alias{plot_spline}
\title{Plot spline curve for a fitted additive model}
\usage{
plot_spline(
  fit,
  variable,
  lambda,
  which = NULL,
  partial = FALSE,
  type = "contrast",
  warnings = TRUE,
  points.par = NULL,
  ...
)
}
\arguments{
\item{fit}{A \code{grpreg} object. The model must have been fit using a \code{expand_spline} object.}

\item{variable}{The name of the variable which will be plotted (character).}

\item{lambda}{Values of the regularization parameter \code{lambda} which will be used for the plot. If a vector is passed, a curve will be drawn for each value of lambda (numeric vector; if a \code{cv.grpreg} object is passed, the \code{lambda} value minimizing cross-validation error will be used as a default; otherwise, there is no default value)}

\item{which}{Index of penalty parameter \code{lambda} which will be used for the plot. If both \code{lambda} and \code{which} are specified, \code{lambda} takes precedence (integer vector).}

\item{partial}{If \code{TRUE}, a scatter plot of the partial residuals is superimposed on the curve (logical; default = \code{FALSE}). If multiple lambdas are specified, the largest value is used to calculate the residuals.}

\item{type}{Type of plot to be produced (default = \code{"contrast"}). The following options are supported:
\itemize{
\item If \code{"conditional"}, the plot returned shows the value of the variable on the x-axis and the change in linear predictor on the y-axis, holding all other variables constant at their mean value.
\item If \code{"contrast"}, the plot returned shows the effect on the linear predictor by moving the x variable away from its mean.
}}

\item{warnings}{If \code{FALSE}, warnings will be suppressed (default = \code{TRUE}).}

\item{points.par}{List of parameters (see \code{\link[=par]{par()}} to pass to \code{\link[=points]{points()}} when \code{partial=TRUE}.}

\item{...}{Further arguments to be passed to \code{plot()}. Note that these arguments also control the appearance of the lines.}
}
\description{
Plots a spline curve for a single variable using a \code{grpreg} or \code{cv.grpreg} object for which an additive model was fit.
}
\details{
\code{plot_spline()} takes a model fit using both the \code{\link[=grpreg]{grpreg()}} and \code{\link[=expand_spline]{expand_spline()}} functions and plots a spline curve for a given variable.
}
\examples{
Data <- gen_nonlinear_data(n=1000)
X <- expand_spline(Data$X)
fit <- grpreg(X, Data$y)
plot_spline(fit, "V02", lambda = 0.03)
plot_spline(fit, "V02", which = c(10, 90))
plot_spline(fit, "V02", lambda = 0.03, partial=TRUE)
plot_spline(fit, "V02", lambda = 0.03, partial=TRUE, type='conditional')
plot_spline(fit, "V02", lambda = 0.03, partial=TRUE, lwd=6, col='yellow',
            points.par=list(pch=9, col='blue'))

op <- par(mfrow=c(3,2), mar=c(4.5, 4.5, 0.25, 0.25))
for (i in 1:6) plot_spline(fit, sprintf("V\%02d", i), lambda = 0.03, partial=TRUE)
par(op)

cvfit <- cv.grpreg(X, Data$y)
plot_spline(cvfit, "V02")
plot_spline(cvfit, "V02", partial=TRUE)
}
