% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_splines.R
\name{all_splines}
\alias{all_splines}
\alias{all_splines.formula}
\alias{all_splines.data.frame}
\title{Fit Exponential Growth Model with Smoothing Spline}
\usage{
all_splines(...)

\method{all_splines}{formula}(formula, data = NULL, optgrid = 50,
  subset = NULL, ...)

\method{all_splines}{data.frame}(data, grouping = NULL, time = "time",
  y = "value", optgrid = 50, ...)
}
\arguments{
\item{\dots}{generic parameters, including parameters passed to \code{\link{smooth.spline}}, see details.}

\item{formula}{model formula specifying dependent, independent and grouping
variables in the form:
\code{dependent ~ independent | group1 + group2 + \dots}.}

\item{data}{data frame of observational data.}

\item{optgrid}{number of steps on the x-axis used for searching the maximum
of the first derivative of the spline.
The default should work in most cases, as long as the data are equally spaced.
A smaller number may lead to non-detectable speed-up, but has the risk that
the search is trapped in a local minimum.}

\item{subset}{a specification of the rows to be used: defaults to all rows.}

\item{grouping}{vector of grouping variables defining subsets in the data frame.}

\item{time}{character vectors with name independent variable.}

\item{y}{character vector with name of dependent variable.}
}
\value{
object with parameters of the fit.
}
\description{
Determine maximum growth rates from log-linear part of the growth curve for
a series of experiments by using smoothing splines.
}
\details{
The method was inspired by an algorithm of Kahm et al. (2010),
  with different settings and assumptions. In the moment, spline fitting
  is always done with log-transformed data, assuming exponential growth
  at the time point of the maximum of its first derivative.

  All the hard work is done by function \code{\link{smooth.spline}} from package
  \pkg{stats}, that is highly user configurable. Normally, smoothness is
  automatically determined via cross-validation. This works well in many cases,
  whereas manual adjustment is required otherwise, e.g. by setting \code{spar}
  to a fixed value \eqn{[0,1]} that also disables cross-validation.
  A typical case where cross validation does not work is, if time dependent
  measurements are taken as pseudoreplicates from the same experimental unit.
}
\examples{

data(bactgrowth)
L <- all_splines(value ~ time | strain + conc + replicate,
                 data = bactgrowth, spar = 0.5)

par(mfrow=c(4, 3))
plot(L)
results <- results(L)
xyplot(mumax ~ log(conc + 1)|strain, data=results)

## fit splines at lower grouping levels
L2 <- all_splines(value ~ time | conc + strain,
                    data = bactgrowth, spar = 0.5)
plot(L2)

## total data set without any grouping
L3 <- all_splines(value ~ time,
                    data = bactgrowth, spar = 0.5)
par(mfrow=c(1, 1))
plot(L3)

}
\references{
Kahm, M., Hasenbrink, G., Lichtenberg-Frate, H., Ludwig, J., Kschischo, M.
2010. grofit: Fitting Biological Growth Curves with R.
Journal of Statistical Software, 33(7), 1-21. URL
\url{http://www.jstatsoft.org/v33/i07/}
}
\seealso{
Other fitting functions: \code{\link{all_easylinear}},
  \code{\link{all_growthmodels}},
  \code{\link{fit_easylinear}},
  \code{\link{fit_growthmodel}}, \code{\link{fit_spline}}
}
