% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wqs.fit.R
\name{wqs.fit}
\alias{wqs.fit}
\title{Group WQS Regression}
\usage{
wqs.fit(
  y,
  y.train = NULL,
  x,
  x.train = NULL,
  z = NULL,
  z.train = NULL,
  x.s,
  B = 100,
  n.quantiles = 4,
  pars = NULL,
  func,
  ineqLB = NULL,
  ineqUB = NULL,
  tol = 1e-06,
  delta = 1e-06
)
}
\arguments{
\item{y}{A vector containing outcomes for validation.}

\item{y.train}{A vector containing outcomes for training. If left as NULL the validation data will be used for training as well.}

\item{x}{A matrix of component data for validation.}

\item{x.train}{A matrix of component data for training. If left as NULL the validation data will be used for training as well.}

\item{z}{A vector or matrix of covariates for validation.}

\item{z.train}{A vector or matrix of covariates for training. If left as NULL the validation data will be used for training as well.}

\item{x.s}{A vector of the number of components in each index.}

\item{B}{The number of bootstrap samples, must be 1 or more.}

\item{n.quantiles}{The number of quantiles to apply to data.}

\item{pars}{A vector of initial values.}

\item{func}{The objective function to be used (must match outcome data type); currently only fun args "continuous" or "binary" are supported.}

\item{ineqLB}{Vector of lower bounds for betas and weights.}

\item{ineqUB}{Vector of upper bounds for betas and weights.}

\item{tol}{Tolerance level for bootstrap convergence.}

\item{delta}{Step size for bootstrap procedure.}
}
\value{
A list of 2 containing the GWQS estimate based on calculated weights
and the GWQS model fit to validation data
}
\description{
This function fits a group weighted quantile sum (GWQS) regression model.
}
\examples{
data("WQSdata")
group_list <- list(c("X1", "X2", "X3"), c("X4", "X7"), c("X5", "X6", "X9", "X8"))
x.s <- make.x.s(WQSdata, 3, group_list)
X <- make.X(WQSdata, 3, group_list)
Y <- WQSdata$y
results <- wqs.fit(y = Y, x = X, x.s = x.s, B=1, func = "continuous")

}
