% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_dirichlet.R
\name{update_dirichlet}
\alias{update_dirichlet}
\title{Update Dirichlet Distribution}
\usage{
update_dirichlet(alpha_0, alpha_1, alpha_2, priors = list())
}
\arguments{
\item{alpha_0}{Double value for alpha_0 (count of failures). Must be 0 or greater.}

\item{alpha_1}{Double value for alpha_1 (count of successes side 1). Must be 0 or greater.}

\item{alpha_2}{Double value for alpha_2 (count of successes side 2). Must be 0 or greater.}

\item{priors}{An optional list object that contains alpha00, alpha01, and alpha02.
Otherwise the function with use \eqn{Dirichlet(1,1,1)} as the prior distribution.}
}
\value{
tibble with columns alpha_0, alpha_1, and alpha_2
}
\description{
This function updates the Dirichlet distribution with the
Dirichlet-Multinomial conjugate prior update rule.
}
\details{
TODO: This function currently only works in 3 dimensions.
Should be extended into N dimensions in the future. Can use ... notation.
}
\examples{
update_dirichlet(alpha_0 = 20, alpha_1 = 5, alpha_2 = 2)
sample_priors_list <- list(alpha00 = 2, alpha01 = 3, alpha02 = 5)
update_dirichlet(alpha_0 = 20, alpha_1 = 5, alpha_2 = 2, priors = sample_priors_list)

}
