% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-array-placeholder.R
\docType{data}
\name{grid.pattern_placeholder}
\alias{grid.pattern_placeholder}
\alias{names_placeholder}
\title{Placeholder image patterned grobs}
\format{
An object of class \code{character} of length 26.
}
\usage{
grid.pattern_placeholder(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  type = "kitten",
  alpha = gp$alpha \%||\% NA_real_,
  aspect_ratio = 1,
  key_scale_factor = 1,
  res = getOption("ggpattern_res", 72),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)

names_placeholder
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{type}{Image source.  \code{names_placeholder} is a vector of supported values.
If you would like only greyscale images append \code{bw} to the name.}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{aspect_ratio}{Override aspect ratio}

\item{key_scale_factor}{Additional scale factor for legend}

\item{res}{Assumed resolution (in pixels per graphic device inch) to use when creating array pattern.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_placeholder()} draws a placeholder image pattern onto the graphic device.
\code{names_placeholder} are character vectors of supported placeholder types.
}
\examples{
  if (requireNamespace("magick")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    # requires internet connection to download from placeholder image websites
    try(grid.pattern_placeholder(x_hex, y_hex, type="bear"))
  }

  print(names_placeholder)
}
\seealso{
\code{\link[=reset_image_cache]{reset_image_cache()}} resets the image cache used by \code{\link[=grid.pattern_image]{grid.pattern_image()}} and \code{grid.pattern_placeholder()}.
}
\keyword{datasets}
