% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logitnorm.R
\name{dlogitnorm}
\alias{dlogitnorm}
\alias{LogitNormal}
\alias{plogitnorm}
\alias{qlogitnorm}
\alias{rlogitnorm}
\title{Logit Normal Distribution}
\usage{
dlogitnorm(q, mu = 0, sigma = 1, log = FALSE)

plogitnorm(q, mu = 0, sigma = 1)

qlogitnorm(p, mu = 0, sigma = 1)

rlogitnorm(n = 1, mu = 0, sigma = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{sigma}{vector of scale parameters.}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{dlogitnorm} returns the density function value for the
provided parameters.
\item \code{plogitnorm} returns the value of the cumulative function
for the provided parameters.
\item \code{qlogitnorm} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{sigma}, this
can be either a vector or a matrix, or an array.
\item \code{rlogitnorm} returns a vector of random variables
generated from the logitnorm distribution. Depending on what was
provided in \code{mu} and \code{sigma}, this can be either a vector
or a matrix or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the distribution that becomes normal after the Logit
transformation.
}
\details{
The distribution has the following density function:

f(y) = 1/(sqrt(2 pi) y (1-y)) exp(-(logit(y) -mu)^2 / (2 sigma^2))

where y is in (0, 1) and logit(y) =log(y/(1-y)).

Both \code{plogitnorm} and \code{qlogitnorm} are returned for the lower
tail of the distribution.

All the functions are defined for the values between 0 and 1.
}
\examples{
x <- dlogitnorm(c(-1000:1000)/200, 0, 1)
plot(c(-1000:1000)/200, x, type="l")

x <- plogitnorm(c(-1000:1000)/200, 0, 1)
plot(c(-1000:1000)/200, x, type="l")

qlogitnorm(c(0.025,0.975), 0, c(1,2))

x <- rlogitnorm(1000, 0, 1)
hist(x)

}
\references{
\itemize{
\item Mead, R. (1965). A Generalised Logit-Normal Distribution.
Biometrics, 21 (3), 721–732. doi: 10.2307/2528553
}
}
\seealso{
\code{\link[greybox]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{distribution}
