% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_linestring_3D.R
\name{create_linestring_3D}
\alias{create_linestring_3D}
\title{Create a 3D Linestring Map}
\usage{
create_linestring_3D(
  data,
  green_index_col,
  mapbox_token,
  output_file = "linestring_map.html",
  color_palette = "interpolateViridis",
  map_center = NULL,
  map_zoom = 11
)
}
\arguments{
\item{data}{An \code{sf} object containing linestring geometries and associated data.}

\item{green_index_col}{Character, name of the column containing the green index values.}

\item{mapbox_token}{Character, Mapbox access token for rendering the map.}

\item{output_file}{Character, name of the output HTML file. Default is "linestring_map.html".}

\item{color_palette}{Character, name of the D3 color palette to use. Default is "interpolateViridis".}

\item{map_center}{Numeric vector, longitude and latitude of the map center. Default is NULL (computed from data).}

\item{map_zoom}{Numeric, initial zoom level of the map. Default is 11.}
}
\value{
NULL. The function creates an HTML file and opens it in the viewer or browser.
}
\description{
This function creates a 3D linestring map using Mapbox GL JS and saves it as an HTML file.
The map visualizes linestring data with an associated green index, allowing for interactive
exploration of the data.
}
\examples{
if (interactive()) {
  # Create example data
  lines <- st_sf(
    id = 1:5,
    geometry = st_sfc(
      st_linestring(matrix(c(0,0, 1,1), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(1,1, 2,2), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(2,2, 3,3), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(3,3, 4,4), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(4,4, 5,5), ncol=2, byrow=TRUE))
    ),
    green_index = runif(5)
  )
  st_crs(lines) <- 4326
  mapbox_token <- "your_mapbox_token"
  create_linestring_3D(lines, "green_index", mapbox_token)
}
}
