% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPML.R
\name{GPML}
\alias{GPML}
\title{Gamma Pseudo Maximum Likelihood, GPML}
\usage{
GPML(y, dist, x, vce_robust = TRUE, data, ...)
}
\arguments{
\item{y}{name (type: character) of the dependent variable in the dataset 
\code{data}, e.g. trade flows.}

\item{dist}{name (type: character) of the distance variable in the dataset 
\code{data} containing a measure of distance between all pairs of bilateral
partners. It is logged automatically when the function is executed.}

\item{x}{vector of names (type: character) of those bilateral variables in 
the dataset \code{data} that should be taken as the independent variables 
in the estimation. If an independent variable is a dummy variable,
it should be of type numeric (0/1) in the dataset. If an independent variable 
is defined as a ratio, it should be logged. 
Unilateral variables such as country dummies or incomes can be added. 
If unilateral metric variables such as GDPs should be used as independent 
variables, those variables have to be logged first and the 
logged variable can be used in \code{x}.
Interaction terms can be added.}

\item{vce_robust}{robust (type: logic) determines whether a robust 
variance-covariance matrix should be used. The default is set to \code{TRUE}.}

\item{data}{name of the dataset to be used (type: character). 
To estimate gravity equations, a square gravity dataset including bilateral 
flows defined by the argument \code{y}, ISO-codes of type character 
(called \code{iso_o} for the country of origin and \code{iso_d} for the 
destination country), a distance measure defined by the argument \code{dist} 
and other potential influences given as a vector in \code{x} are required. 
All dummy variables should be of type numeric (0/1). Missing trade flows as 
well as incomplete rows should be excluded from the dataset. 
Flows equal to zero have to be excluded as the gamma distribution 
is used. 
When using panel data, a variable for the time may be included in the 
dataset. Note that the variable for the time dimension should be of 
type: factor. See the references for more information on panel data.}

\item{...}{additional arguments to be passed to functions used by 
\code{GPML}.}
}
\value{
The function returns the summary of the estimated gravity model similar to a 
\code{\link[stats]{glm}}-object.
}
\description{
\code{GPML} estimates gravity models in their 
multiplicative form via Gamma Pseudo Maximum Likelihood.
}
\details{
\code{GPML} is an estimation method for gravity models
belonging to generalized linear models.
It is estimated via \code{\link[glm2]{glm2}} using the gamma distribution and a log-link.
To execute the function a square gravity dataset with all pairs of 
countries, ISO-codes for the country of origin and destination, a measure of 
distance between the bilateral partners as well as all 
information that should be considered as dependent an independent 
variables is needed. 
Make sure the ISO-codes are of type "character".
Missing bilateral flows as well as incomplete rows should be 
excluded from the dataset.  
Flows equal to zero have to be excluded as the gamma distribution is used. 
For similar functions, utilizing the multiplicative form via the log-link, 
but different distributions, see \code{\link[gravity]{PPML}}, \code{\link[gravity]{NLS}}, and \code{\link[gravity]{NBPML}}.

\code{GPML} estimation can be used for both, cross-sectional as well as 
panel data. 
It is up to the user to ensure that the functions can be applied 
to panel data. 
Depending on the panel dataset and the variables - 
specifically the type of fixed effects - 
included in the model, it may easily occur that the model is not computable. 
Also, note that by including bilateral fixed effects such as country-pair 
effects, the coefficients of time-invariant observables such as distance 
can no longer be estimated. 
Depending on the specific model, the code of the 
respective function may has to be changed in order to exclude the distance 
variable from the estimation. 
At the very least, the user should take special 
care with respect to the meaning of the estimated coefficients and variances 
as well as the decision about which effects to include in the estimation. 
When using panel data, the parameter and variance estimation of the models 
may have to be changed accordingly.
For a comprehensive overview of gravity models for panel data 
see Egger and Pfaffermayr (2003), Gomez-Herrera (2013) and Head, Mayer and 
Ries (2010) as well as the references therein.
}
\examples{
\dontrun{
data(Gravity)

Gravity$lgdp_o <- log(Gravity$gdp_o)
Gravity$lgdp_d <- log(Gravity$gdp_d)

GPML(y="flow", dist="distw", x=c("rta", "lgdp_o", "lgdp_d"), 
vce_robust=TRUE, data=Gravity)

GPML(y="flow", dist="distw", x=c("rta", "iso_o", "iso_d"), 
vce_robust=TRUE, data=Gravity)
}

}
\references{
For more information on the estimation of gravity equations via Gamma
Pseudo maximum Likelihood see

Santos-Silva, J. M. C. and Tenreyro, S. (2006) <DOI:10.1162/rest.88.4.641> 

For more information on gravity models, theoretical foundations and
estimation methods in general see 

Anderson, J. E. (1979) <DOI:10.12691/wjssh-2-2-5>

Anderson, J. E. (2010) <DOI:10.3386/w16576>

Anderson, J. E. and van Wincoop, E. (2003) <DOI:10.3386/w8079> 

Baier, S. L. and Bergstrand, J. H. (2009) <DOI:10.1016/j.jinteco.2008.10.004>

Baier, S. L. and Bergstrand, J. H. (2010) in Van Bergeijk, P. A., & Brakman, S. (Eds.) (2010) chapter 4 <DOI:10.1111/j.1467-9396.2011.01000.x>

Head, K., Mayer, T., & Ries, J. (2010) <DOI:10.1016/j.jinteco.2010.01.002>

Head, K. and Mayer, T. (2014) <DOI:10.1016/B978-0-444-54314-1.00003-3>

and the citations therein.


See \href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook} for gravity datasets and Stata code for estimating gravity models.


For estimating gravity equations using panel data see 

Egger, P., & Pfaffermayr, M. (2003) <DOI:10.1007/s001810200146>

Gomez-Herrera, E. (2013) <DOI:10.1007/s00181-012-0576-2>

and the references therein.
}
\seealso{
\code{\link[glm2]{glm2}}, \code{\link[lmtest]{coeftest}}, 
\code{\link[sandwich]{vcovHC}}
}
