% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fy.year.R
\name{is.fy}
\alias{is.fy}
\alias{fy.year}
\alias{yr2fy}
\alias{fy2yr}
\alias{fy2date}
\alias{date2fy}
\title{Convenience functions for dealing with financial years}
\arguments{
\item{yr_ending}{An integer representing a year.}

\item{fy.yr}{A string suspected to be a financial year.}

\item{date}{A string or date for which the financial year is desired. Note that \code{yr2fy} does not check its argument is an integer.}

\item{assume1901_2100}{For \code{yr2fy}, assume that \code{yr_ending} is between 1901 and 2100, 
for performance. By default, set to \code{getOption("grattan.assume1901_2100", TRUE)}.}
}
\value{
For \code{is.fy}, a logical, whether its argument is a financial year.
The following forms are allowed: \code{2012-13}, \code{201213}, \code{2012 13}, only.
For \code{fy.year}, \code{yr2fy}, and \code{date2fy}, the financial year. 
For the inverses, a numeric corresponding to the year.

\code{fy.year} is a deprecated alias for \code{yr2fy}, the latter is slightly more efficient, as well as more declarative.

\code{fy2yr} converts a financial year to the year ending: \code{fy2yr("2016-17")} returns 2017. \code{yr2fy} is the inverse: \code{yr2fy(fy2yr("2016-17")) == "2016-17"}.

\code{fy2date} converts a financial year to the 30 June of the financial year ending.

\code{date2fy} converts a date to the corresponding financial year.
}
\description{
From grattan v1.7.1.4, these are reexports from the \code{\link[fy]{fy-package}}.
}
\details{
The following forms are permitted: \code{2012-13}, \code{201213}, \code{2012 13}, only.
However, the \code{2012-13} form is preferred and will improve performance.
}
\examples{
is.fy("2012-13")
is.fy("2012-14")
yr2fy(2012)
fy2yr("2015-16")
date2fy("2014-08-09")
}
