% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressivity.R
\name{progressivity}
\alias{progressivity}
\title{Compute the progressivity}
\usage{
progressivity(income, tax, measure = c("Reynolds-Smolensky", "Kakwani"))
}
\arguments{
\item{income}{Pre-tax income.}

\item{tax}{Tax paid.}

\item{measure}{Currently, only "Reynolds-Smolensky" progressivity is calculated:
\deqn{G_Y - G_Z} where \eqn{G_Y} is the Gini coefficient of \code{income}
and \eqn{G_X} is the Gini coefficient of post-tax income.}
}
\value{
The progressivity measure. Positive for progressive tax systems, and higher the
value the more progressive the system.
}
\description{
Compute the progressivity
}
\examples{

I <- c(10e3, 20e3, 50e3, 100e3, 150e3)
progressivity(I, 0.3 * I) # zero
progressivity(I, income_tax(I, "2017-18"))

}
